/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.shardingsphere.distsql.handler.query.RQLExecutor;
import org.apache.shardingsphere.infra.config.algorithm.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.distsql.handler.enums.ShardingStrategyType;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowDefaultShardingStrategyStatement;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

public final class ShowDefaultShardingStrategyExecutor
implements RQLExecutor<ShowDefaultShardingStrategyStatement> {
    public Collection<LocalDataQueryResultRow> getRows(ShardingSphereDatabase database, ShowDefaultShardingStrategyStatement sqlStatement) {
        Optional shardingRule = database.getRuleMetaData().findSingleRule(ShardingRule.class);
        return shardingRule.map(this::buildData).orElse(Collections.emptyList());
    }

    private Collection<LocalDataQueryResultRow> buildData(ShardingRule rule) {
        LinkedList<LocalDataQueryResultRow> result = new LinkedList<LocalDataQueryResultRow>();
        ShardingRuleConfiguration ruleConfig = (ShardingRuleConfiguration)rule.getConfiguration();
        result.add(this.buildDataItem("TABLE", ruleConfig, ruleConfig.getDefaultTableShardingStrategy()));
        result.add(this.buildDataItem("DATABASE", ruleConfig, ruleConfig.getDefaultDatabaseShardingStrategy()));
        return result;
    }

    private LocalDataQueryResultRow buildDataItem(String defaultType, ShardingRuleConfiguration ruleConfig, ShardingStrategyConfiguration strategyConfig) {
        if (null == strategyConfig) {
            return new LocalDataQueryResultRow(new Object[]{defaultType, "", "", "", "", ""});
        }
        ShardingStrategyType strategyType = ShardingStrategyType.getValueOf(strategyConfig);
        if (strategyType == ShardingStrategyType.NONE) {
            return new LocalDataQueryResultRow(new Object[]{defaultType, "NONE", "", "", "", ""});
        }
        AlgorithmConfiguration algorithmConfig = (AlgorithmConfiguration)ruleConfig.getShardingAlgorithms().get(strategyConfig.getShardingAlgorithmName());
        Iterator<String> iterator = strategyType.getConfigurationContents(strategyConfig).iterator();
        String shardingColumn = iterator.next();
        String algorithmName = iterator.next();
        return new LocalDataQueryResultRow(new Object[]{defaultType, strategyType.toString(), shardingColumn, algorithmName, algorithmConfig.getType(), algorithmConfig.getProps().toString()});
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("name", "type", "sharding_column", "sharding_algorithm_name", "sharding_algorithm_type", "sharding_algorithm_props");
    }

    public Class<ShowDefaultShardingStrategyStatement> getType() {
        return ShowDefaultShardingStrategyStatement.class;
    }
}

