/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.shardingsphere.distsql.handler.query.RQLExecutor;
import org.apache.shardingsphere.infra.config.algorithm.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.props.PropertiesConverter;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowShardingAlgorithmsStatement;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

public final class ShowShardingAlgorithmExecutor
implements RQLExecutor<ShowShardingAlgorithmsStatement> {
    public Collection<LocalDataQueryResultRow> getRows(ShardingSphereDatabase database, ShowShardingAlgorithmsStatement sqlStatement) {
        Optional rule = database.getRuleMetaData().findSingleRule(ShardingRule.class);
        Iterator data = rule.map(optional -> ((ShardingRuleConfiguration)optional.getConfiguration()).getShardingAlgorithms().entrySet().iterator()).orElse(Collections.emptyIterator());
        LinkedList<LocalDataQueryResultRow> result = new LinkedList<LocalDataQueryResultRow>();
        while (data.hasNext()) {
            Map.Entry entry = (Map.Entry)data.next();
            result.add(new LocalDataQueryResultRow(new Object[]{entry.getKey(), ((AlgorithmConfiguration)entry.getValue()).getType(), this.buildProps(((AlgorithmConfiguration)entry.getValue()).getProps())}));
        }
        return result;
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("name", "type", "props");
    }

    private String buildProps(Properties props) {
        return null == props ? "" : PropertiesConverter.convert((Properties)props);
    }

    public Class<ShowShardingAlgorithmsStatement> getType() {
        return ShowShardingAlgorithmsStatement.class;
    }
}

