/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.distsql.handler.query.RQLExecutor;
import org.apache.shardingsphere.infra.config.algorithm.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowShardingAuditorsStatement;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

public final class ShowShardingAuditorsExecutor
implements RQLExecutor<ShowShardingAuditorsStatement> {
    public Collection<LocalDataQueryResultRow> getRows(ShardingSphereDatabase database, ShowShardingAuditorsStatement sqlStatement) {
        Optional rule = database.getRuleMetaData().findSingleRule(ShardingRule.class);
        Iterator data = rule.map(optional -> ((ShardingRuleConfiguration)optional.getConfiguration()).getAuditors().entrySet().iterator()).orElse(Collections.emptyIterator());
        LinkedList<LocalDataQueryResultRow> result = new LinkedList<LocalDataQueryResultRow>();
        while (data.hasNext()) {
            Map.Entry entry = (Map.Entry)data.next();
            result.add(new LocalDataQueryResultRow(new Object[]{entry.getKey(), ((AlgorithmConfiguration)entry.getValue()).getType(), ((AlgorithmConfiguration)entry.getValue()).getProps()}));
        }
        return result;
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("name", "type", "props");
    }

    public Class<ShowShardingAuditorsStatement> getType() {
        return ShowShardingAuditorsStatement.class;
    }
}

