/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.handler.query.RQLExecutor;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowShardingTableNodesStatement;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.TableRule;

public final class ShowShardingTableNodesExecutor
implements RQLExecutor<ShowShardingTableNodesStatement> {
    private static final String NAME = "name";
    private static final String NODES = "nodes";

    public Collection<LocalDataQueryResultRow> getRows(ShardingSphereDatabase database, ShowShardingTableNodesStatement sqlStatement) {
        Optional shardingRule = database.getRuleMetaData().findSingleRule(ShardingRule.class);
        if (!shardingRule.isPresent()) {
            return Collections.emptyList();
        }
        LinkedList<LocalDataQueryResultRow> result = new LinkedList<LocalDataQueryResultRow>();
        String tableName = sqlStatement.getTableName();
        if (null == tableName) {
            for (Map.Entry entry : ((ShardingRule)shardingRule.get()).getTableRules().entrySet()) {
                result.add(new LocalDataQueryResultRow(new Object[]{entry.getKey(), this.getTableNodes((TableRule)entry.getValue())}));
            }
        } else {
            result.add(new LocalDataQueryResultRow(new Object[]{tableName, this.getTableNodes(((ShardingRule)shardingRule.get()).getTableRule(tableName))}));
        }
        return result;
    }

    private String getTableNodes(TableRule tableRule) {
        return tableRule.getActualDataNodes().stream().map(DataNode::format).collect(Collectors.joining(", "));
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList(NAME, NODES);
    }

    public Class<ShowShardingTableNodesStatement> getType() {
        return ShowShardingTableNodesStatement.class;
    }
}

