/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.shardingsphere.distsql.handler.query.RQLExecutor;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableReferenceRuleConfiguration;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowShardingTableReferenceRulesStatement;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

public final class ShowShardingTableReferenceRuleExecutor
implements RQLExecutor<ShowShardingTableReferenceRulesStatement> {
    public Collection<LocalDataQueryResultRow> getRows(ShardingSphereDatabase database, ShowShardingTableReferenceRulesStatement sqlStatement) {
        Optional rule = database.getRuleMetaData().findSingleRule(ShardingRule.class);
        if (!rule.isPresent()) {
            return Collections.emptyList();
        }
        LinkedList<LocalDataQueryResultRow> result = new LinkedList<LocalDataQueryResultRow>();
        for (ShardingTableReferenceRuleConfiguration referenceRule : ((ShardingRuleConfiguration)((ShardingRule)rule.get()).getConfiguration()).getBindingTableGroups()) {
            if (null != sqlStatement.getRuleName() && !referenceRule.getName().equalsIgnoreCase(sqlStatement.getRuleName())) continue;
            result.add(new LocalDataQueryResultRow(new Object[]{referenceRule.getName(), referenceRule.getReference()}));
        }
        return result;
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("name", "sharding_table_reference");
    }

    public Class<ShowShardingTableReferenceRulesStatement> getType() {
        return ShowShardingTableReferenceRulesStatement.class;
    }
}

