/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.handler.query.RQLExecutor;
import org.apache.shardingsphere.infra.config.algorithm.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.props.PropertiesConverter;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.audit.ShardingAuditStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.keygen.KeyGenerateStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ComplexShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.NoneShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.StandardShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowShardingTableRulesStatement;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

public final class ShowShardingTableRuleExecutor
implements RQLExecutor<ShowShardingTableRulesStatement> {
    private ShardingRuleConfiguration shardingRuleConfig;

    public Collection<LocalDataQueryResultRow> getRows(ShardingSphereDatabase database, ShowShardingTableRulesStatement sqlStatement) {
        Iterator<Object> autoTables;
        Iterator<Object> tables;
        Optional rule = database.getRuleMetaData().findSingleRule(ShardingRule.class);
        if (!rule.isPresent()) {
            return Collections.emptyList();
        }
        ShardingRuleConfiguration config = (ShardingRuleConfiguration)((ShardingRule)rule.get()).getConfiguration();
        String tableName = sqlStatement.getTableName();
        if (null == tableName) {
            tables = config.getTables().iterator();
            autoTables = config.getAutoTables().iterator();
        } else {
            tables = config.getTables().stream().filter(each -> tableName.equalsIgnoreCase(each.getLogicTable())).collect(Collectors.toList()).iterator();
            autoTables = config.getAutoTables().stream().filter(each -> tableName.equalsIgnoreCase(each.getLogicTable())).collect(Collectors.toList()).iterator();
        }
        this.shardingRuleConfig = config;
        LinkedList<LocalDataQueryResultRow> result = new LinkedList<LocalDataQueryResultRow>();
        while (tables.hasNext()) {
            result.add(this.buildTableRowData((ShardingTableRuleConfiguration)tables.next()));
        }
        while (autoTables.hasNext()) {
            result.add(this.buildAutoTableRowData((ShardingAutoTableRuleConfiguration)autoTables.next()));
        }
        return result;
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("table", "actual_data_nodes", "actual_data_sources", "database_strategy_type", "database_sharding_column", "database_sharding_algorithm_type", "database_sharding_algorithm_props", "table_strategy_type", "table_sharding_column", "table_sharding_algorithm_type", "table_sharding_algorithm_props", "key_generate_column", "key_generator_type", "key_generator_props", "auditor_types", "allow_hint_disable");
    }

    private LocalDataQueryResultRow buildTableRowData(ShardingTableRuleConfiguration shardingTableRuleConfig) {
        Optional<ShardingStrategyConfiguration> databaseShardingStrategyConfig = this.getDatabaseShardingStrategy(shardingTableRuleConfig);
        Optional<ShardingStrategyConfiguration> tableShardingStrategyConfig = this.getTableShardingStrategy(shardingTableRuleConfig.getTableShardingStrategy());
        return new LocalDataQueryResultRow(new Object[]{shardingTableRuleConfig.getLogicTable(), shardingTableRuleConfig.getActualDataNodes(), "", databaseShardingStrategyConfig.map(this::getStrategyType).orElse(""), databaseShardingStrategyConfig.map(this::getShardingColumn).orElse(""), databaseShardingStrategyConfig.map(this::getAlgorithmType).orElse(""), databaseShardingStrategyConfig.map(this::getAlgorithmProperties).orElse(""), tableShardingStrategyConfig.map(this::getStrategyType).orElse(""), tableShardingStrategyConfig.map(this::getShardingColumn).orElse(""), tableShardingStrategyConfig.map(this::getAlgorithmType).orElse(""), tableShardingStrategyConfig.map(this::getAlgorithmProperties).orElse(""), this.getKeyGenerateColumn(shardingTableRuleConfig.getKeyGenerateStrategy()), this.getKeyGeneratorType(shardingTableRuleConfig.getKeyGenerateStrategy()), this.getKeyGeneratorProps(shardingTableRuleConfig.getKeyGenerateStrategy()), this.getAuditorTypes(shardingTableRuleConfig.getAuditStrategy()), this.getAllowHintDisable(shardingTableRuleConfig.getAuditStrategy())});
    }

    private LocalDataQueryResultRow buildAutoTableRowData(ShardingAutoTableRuleConfiguration shardingAutoTableRuleConfig) {
        Optional<ShardingStrategyConfiguration> tableShardingStrategyConfig = this.getTableShardingStrategy(shardingAutoTableRuleConfig.getShardingStrategy());
        return new LocalDataQueryResultRow(new Object[]{shardingAutoTableRuleConfig.getLogicTable(), "", shardingAutoTableRuleConfig.getActualDataSources(), "", "", "", "", tableShardingStrategyConfig.map(this::getStrategyType).orElse(""), tableShardingStrategyConfig.map(this::getShardingColumn).orElse(""), tableShardingStrategyConfig.map(this::getAlgorithmType).orElse(""), tableShardingStrategyConfig.map(this::getAlgorithmProperties).orElse(""), this.getKeyGenerateColumn(shardingAutoTableRuleConfig.getKeyGenerateStrategy()), this.getKeyGeneratorType(shardingAutoTableRuleConfig.getKeyGenerateStrategy()), this.getKeyGeneratorProps(shardingAutoTableRuleConfig.getKeyGenerateStrategy()), this.getAuditorTypes(shardingAutoTableRuleConfig.getAuditStrategy()), this.getAllowHintDisable(shardingAutoTableRuleConfig.getAuditStrategy())});
    }

    private String getShardingColumn(ShardingStrategyConfiguration shardingStrategyConfig) {
        if (shardingStrategyConfig instanceof StandardShardingStrategyConfiguration) {
            return ((StandardShardingStrategyConfiguration)shardingStrategyConfig).getShardingColumn();
        }
        if (shardingStrategyConfig instanceof ComplexShardingStrategyConfiguration) {
            return ((ComplexShardingStrategyConfiguration)shardingStrategyConfig).getShardingColumns();
        }
        return "";
    }

    private String getAlgorithmType(ShardingStrategyConfiguration shardingStrategyConfig) {
        return shardingStrategyConfig instanceof NoneShardingStrategyConfiguration ? "" : this.getAlgorithmConfiguration(shardingStrategyConfig.getShardingAlgorithmName()).getType();
    }

    private String getAlgorithmProperties(ShardingStrategyConfiguration shardingStrategyConfig) {
        return shardingStrategyConfig instanceof NoneShardingStrategyConfiguration ? "" : PropertiesConverter.convert((Properties)this.getAlgorithmConfiguration(shardingStrategyConfig.getShardingAlgorithmName()).getProps());
    }

    private Optional<ShardingStrategyConfiguration> getDatabaseShardingStrategy(ShardingTableRuleConfiguration shardingTableRuleConfig) {
        return null == shardingTableRuleConfig.getDatabaseShardingStrategy() ? Optional.ofNullable(this.shardingRuleConfig.getDefaultDatabaseShardingStrategy()) : Optional.of(shardingTableRuleConfig.getDatabaseShardingStrategy());
    }

    private AlgorithmConfiguration getAlgorithmConfiguration(String algorithmName) {
        return (AlgorithmConfiguration)this.shardingRuleConfig.getShardingAlgorithms().get(algorithmName);
    }

    private String getStrategyType(ShardingStrategyConfiguration shardingStrategyConfig) {
        return shardingStrategyConfig.getType();
    }

    private Optional<ShardingStrategyConfiguration> getTableShardingStrategy(ShardingStrategyConfiguration shardingStrategyConfig) {
        return null == shardingStrategyConfig ? Optional.ofNullable(this.shardingRuleConfig.getDefaultTableShardingStrategy()) : Optional.of(shardingStrategyConfig);
    }

    private String getKeyGenerateColumn(KeyGenerateStrategyConfiguration keyGenerateStrategyConfig) {
        return this.getKeyGenerateStrategyConfiguration(keyGenerateStrategyConfig).isPresent() ? this.getKeyGenerateStrategyConfiguration(keyGenerateStrategyConfig).get().getColumn() : "";
    }

    private String getKeyGeneratorType(KeyGenerateStrategyConfiguration originalKeyGenerateStrategyConfig) {
        Optional<KeyGenerateStrategyConfiguration> keyGenerateStrategyConfig = this.getKeyGenerateStrategyConfiguration(originalKeyGenerateStrategyConfig);
        return keyGenerateStrategyConfig.isPresent() ? ((AlgorithmConfiguration)this.shardingRuleConfig.getKeyGenerators().get(keyGenerateStrategyConfig.get().getKeyGeneratorName())).getType() : "";
    }

    private String getKeyGeneratorProps(KeyGenerateStrategyConfiguration keyGenerateStrategyConfig) {
        return this.getKeyGenerateStrategyConfiguration(keyGenerateStrategyConfig).map(optional -> PropertiesConverter.convert((Properties)((AlgorithmConfiguration)this.shardingRuleConfig.getKeyGenerators().get(optional.getKeyGeneratorName())).getProps())).orElse("");
    }

    private Optional<KeyGenerateStrategyConfiguration> getKeyGenerateStrategyConfiguration(KeyGenerateStrategyConfiguration keyGenerateStrategyConfig) {
        return null == keyGenerateStrategyConfig ? Optional.ofNullable(this.shardingRuleConfig.getDefaultKeyGenerateStrategy()) : Optional.of(keyGenerateStrategyConfig);
    }

    private String getAuditorTypes(ShardingAuditStrategyConfiguration shardingAuditStrategyConfig) {
        Optional<ShardingAuditStrategyConfiguration> auditStrategyConfig = this.getShardingAuditStrategyConfiguration(shardingAuditStrategyConfig);
        LinkedList<String> auditorTypes = new LinkedList<String>();
        if (auditStrategyConfig.isPresent()) {
            for (String each : auditStrategyConfig.get().getAuditorNames()) {
                auditorTypes.add(((AlgorithmConfiguration)this.shardingRuleConfig.getAuditors().get(each)).getType());
            }
        }
        return auditorTypes.isEmpty() ? "" : String.join((CharSequence)",", auditorTypes);
    }

    private String getAllowHintDisable(ShardingAuditStrategyConfiguration shardingAuditStrategyConfig) {
        return this.getShardingAuditStrategyConfiguration(shardingAuditStrategyConfig).isPresent() ? Boolean.toString(this.getShardingAuditStrategyConfiguration(shardingAuditStrategyConfig).get().isAllowHintDisable()) : "";
    }

    private Optional<ShardingAuditStrategyConfiguration> getShardingAuditStrategyConfiguration(ShardingAuditStrategyConfiguration shardingAuditStrategyConfig) {
        return null == shardingAuditStrategyConfig ? Optional.ofNullable(this.shardingRuleConfig.getDefaultAuditStrategy()) : Optional.of(shardingAuditStrategyConfig);
    }

    public Class<ShowShardingTableRulesStatement> getType() {
        return ShowShardingTableRulesStatement.class;
    }
}

