/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.shardingsphere.distsql.handler.query.RQLExecutor;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowShardingTableRulesUsedAlgorithmStatement;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

public final class ShowShardingTableRulesUsedAlgorithmExecutor
implements RQLExecutor<ShowShardingTableRulesUsedAlgorithmStatement> {
    public Collection<LocalDataQueryResultRow> getRows(ShardingSphereDatabase database, ShowShardingTableRulesUsedAlgorithmStatement sqlStatement) {
        LinkedList<LocalDataQueryResultRow> result = new LinkedList<LocalDataQueryResultRow>();
        Optional rule = database.getRuleMetaData().findSingleRule(ShardingRule.class);
        rule.ifPresent(optional -> this.requireResult(sqlStatement, (Collection<LocalDataQueryResultRow>)result, (ShardingRule)optional));
        return result;
    }

    private void requireResult(ShowShardingTableRulesUsedAlgorithmStatement statement, Collection<LocalDataQueryResultRow> result, ShardingRule rule) {
        if (!statement.getShardingAlgorithmName().isPresent()) {
            return;
        }
        ShardingRuleConfiguration config = (ShardingRuleConfiguration)rule.getConfiguration();
        String algorithmName = (String)statement.getShardingAlgorithmName().get();
        boolean matchDefaultDatabaseShardingStrategy = null != config.getDefaultDatabaseShardingStrategy() && algorithmName.equals(config.getDefaultDatabaseShardingStrategy().getShardingAlgorithmName());
        boolean matchDefaultTableShardingStrategy = null != config.getDefaultTableShardingStrategy() && algorithmName.equals(config.getDefaultTableShardingStrategy().getShardingAlgorithmName());
        config.getTables().forEach(each -> {
            if (this.isMatchDatabaseShardingStrategy((ShardingTableRuleConfiguration)each, algorithmName, matchDefaultDatabaseShardingStrategy) || this.isMatchTableShardingStrategy((ShardingTableRuleConfiguration)each, algorithmName, matchDefaultTableShardingStrategy)) {
                result.add(new LocalDataQueryResultRow(new Object[]{"table", each.getLogicTable()}));
            }
        });
        config.getAutoTables().forEach(each -> {
            if (null != each.getShardingStrategy() && algorithmName.equals(each.getShardingStrategy().getShardingAlgorithmName())) {
                result.add(new LocalDataQueryResultRow(new Object[]{"auto_table", each.getLogicTable()}));
            }
        });
    }

    private boolean isMatchDatabaseShardingStrategy(ShardingTableRuleConfiguration tableRuleConfig, String algorithmName, boolean matchDefaultDatabaseShardingStrategy) {
        return this.isMatchDatabaseShardingStrategy(tableRuleConfig, algorithmName) || this.isMatchDefaultDatabaseShardingStrategy(tableRuleConfig, matchDefaultDatabaseShardingStrategy);
    }

    private boolean isMatchDatabaseShardingStrategy(ShardingTableRuleConfiguration tableRuleConfig, String algorithmName) {
        return null != tableRuleConfig.getDatabaseShardingStrategy() && algorithmName.equals(tableRuleConfig.getDatabaseShardingStrategy().getShardingAlgorithmName());
    }

    private boolean isMatchDefaultDatabaseShardingStrategy(ShardingTableRuleConfiguration tableRuleConfig, boolean matchDefaultDatabaseShardingStrategy) {
        return null == tableRuleConfig.getDatabaseShardingStrategy() && matchDefaultDatabaseShardingStrategy;
    }

    private boolean isMatchTableShardingStrategy(ShardingTableRuleConfiguration tableRuleConfig, String algorithmName, boolean matchDefaultTableShardingStrategy) {
        return this.isMatchTableShardingStrategy(tableRuleConfig, algorithmName) || this.isMatchDefaultTableShardingStrategy(tableRuleConfig, matchDefaultTableShardingStrategy);
    }

    private boolean isMatchTableShardingStrategy(ShardingTableRuleConfiguration tableRuleConfig, String algorithmName) {
        return null != tableRuleConfig.getTableShardingStrategy() && algorithmName.equals(tableRuleConfig.getTableShardingStrategy().getShardingAlgorithmName());
    }

    private boolean isMatchDefaultTableShardingStrategy(ShardingTableRuleConfiguration tableRuleConfig, boolean matchDefaultTableShardingStrategy) {
        return null == tableRuleConfig.getTableShardingStrategy() && matchDefaultTableShardingStrategy;
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("type", "name");
    }

    public Class<ShowShardingTableRulesUsedAlgorithmStatement> getType() {
        return ShowShardingTableRulesUsedAlgorithmStatement.class;
    }
}

