/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.shardingsphere.distsql.handler.query.RQLExecutor;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowShardingTableRulesUsedAuditorStatement;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

public final class ShowShardingTableRulesUsedAuditorExecutor
implements RQLExecutor<ShowShardingTableRulesUsedAuditorStatement> {
    public Collection<LocalDataQueryResultRow> getRows(ShardingSphereDatabase database, ShowShardingTableRulesUsedAuditorStatement sqlStatement) {
        LinkedList<LocalDataQueryResultRow> result = new LinkedList<LocalDataQueryResultRow>();
        database.getRuleMetaData().findSingleRule(ShardingRule.class).ifPresent(optional -> this.requireResult(sqlStatement, (Collection<LocalDataQueryResultRow>)result, (ShardingRule)optional));
        return result;
    }

    private void requireResult(ShowShardingTableRulesUsedAuditorStatement statement, Collection<LocalDataQueryResultRow> result, ShardingRule rule) {
        if (!statement.getAuditorName().isPresent()) {
            return;
        }
        ShardingRuleConfiguration config = (ShardingRuleConfiguration)rule.getConfiguration();
        config.getTables().forEach(each -> {
            if (null != each.getAuditStrategy() && each.getAuditStrategy().getAuditorNames().contains(statement.getAuditorName().get())) {
                result.add(new LocalDataQueryResultRow(new Object[]{"table", each.getLogicTable()}));
            }
        });
        config.getAutoTables().forEach(each -> {
            if (null != each.getAuditStrategy() && each.getAuditStrategy().getAuditorNames().contains(statement.getAuditorName().get())) {
                result.add(new LocalDataQueryResultRow(new Object[]{"auto_table", each.getLogicTable()}));
            }
        });
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("type", "name");
    }

    public Class<ShowShardingTableRulesUsedAuditorStatement> getType() {
        return ShowShardingTableRulesUsedAuditorStatement.class;
    }
}

