/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.query;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.shardingsphere.distsql.handler.query.RQLExecutor;
import org.apache.shardingsphere.infra.config.algorithm.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.props.PropertiesConverter;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowUnusedShardingAlgorithmsStatement;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

public final class ShowUnusedShardingAlgorithmsExecutor
implements RQLExecutor<ShowUnusedShardingAlgorithmsStatement> {
    public Collection<LocalDataQueryResultRow> getRows(ShardingSphereDatabase database, ShowUnusedShardingAlgorithmsStatement sqlStatement) {
        Optional rule = database.getRuleMetaData().findSingleRule(ShardingRule.class);
        if (!rule.isPresent()) {
            return Collections.emptyList();
        }
        ShardingRuleConfiguration shardingRuleConfig = (ShardingRuleConfiguration)((ShardingRule)rule.get()).getConfiguration();
        LinkedList<LocalDataQueryResultRow> result = new LinkedList<LocalDataQueryResultRow>();
        Collection<String> inUsedAlgorithms = this.getUsedShardingAlgorithms(shardingRuleConfig);
        for (Map.Entry entry : shardingRuleConfig.getShardingAlgorithms().entrySet()) {
            if (inUsedAlgorithms.contains(entry.getKey())) continue;
            result.add(new LocalDataQueryResultRow(new Object[]{entry.getKey(), ((AlgorithmConfiguration)entry.getValue()).getType(), this.buildProps(((AlgorithmConfiguration)entry.getValue()).getProps())}));
        }
        return result;
    }

    private Collection<String> getUsedShardingAlgorithms(ShardingRuleConfiguration shardingRuleConfig) {
        ShardingStrategyConfiguration databaseShardingStrategy;
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        shardingRuleConfig.getTables().forEach(each -> {
            if (null != each.getDatabaseShardingStrategy()) {
                result.add(each.getDatabaseShardingStrategy().getShardingAlgorithmName());
            }
            if (null != each.getTableShardingStrategy()) {
                result.add(each.getTableShardingStrategy().getShardingAlgorithmName());
            }
        });
        shardingRuleConfig.getAutoTables().stream().filter(each -> null != each.getShardingStrategy()).forEach(each -> result.add(each.getShardingStrategy().getShardingAlgorithmName()));
        ShardingStrategyConfiguration tableShardingStrategy = shardingRuleConfig.getDefaultTableShardingStrategy();
        if (null != tableShardingStrategy && !Strings.isNullOrEmpty((String)tableShardingStrategy.getShardingAlgorithmName())) {
            result.add(tableShardingStrategy.getShardingAlgorithmName());
        }
        if (null != (databaseShardingStrategy = shardingRuleConfig.getDefaultDatabaseShardingStrategy()) && !Strings.isNullOrEmpty((String)databaseShardingStrategy.getShardingAlgorithmName())) {
            result.add(databaseShardingStrategy.getShardingAlgorithmName());
        }
        return result;
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("name", "type", "props");
    }

    private String buildProps(Properties props) {
        return null == props ? "" : PropertiesConverter.convert((Properties)props);
    }

    public Class<ShowUnusedShardingAlgorithmsStatement> getType() {
        return ShowUnusedShardingAlgorithmsStatement.class;
    }
}

