/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.distsql.handler.query.RQLExecutor;
import org.apache.shardingsphere.infra.config.algorithm.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.audit.ShardingAuditStrategyConfiguration;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowUnusedShardingAuditorsStatement;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

public final class ShowUnusedShardingAuditorsExecutor
implements RQLExecutor<ShowUnusedShardingAuditorsStatement> {
    public Collection<LocalDataQueryResultRow> getRows(ShardingSphereDatabase database, ShowUnusedShardingAuditorsStatement sqlStatement) {
        Optional rule = database.getRuleMetaData().findSingleRule(ShardingRule.class);
        if (!rule.isPresent()) {
            return Collections.emptyList();
        }
        ShardingRuleConfiguration shardingRuleConfig = (ShardingRuleConfiguration)((ShardingRule)rule.get()).getConfiguration();
        Collection<String> inUsedAuditors = this.getUsedAuditors(shardingRuleConfig);
        LinkedList<LocalDataQueryResultRow> result = new LinkedList<LocalDataQueryResultRow>();
        for (Map.Entry entry : shardingRuleConfig.getAuditors().entrySet()) {
            if (inUsedAuditors.contains(entry.getKey())) continue;
            result.add(new LocalDataQueryResultRow(new Object[]{entry.getKey(), ((AlgorithmConfiguration)entry.getValue()).getType(), ((AlgorithmConfiguration)entry.getValue()).getProps().toString()}));
        }
        return result;
    }

    private Collection<String> getUsedAuditors(ShardingRuleConfiguration shardingRuleConfig) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        shardingRuleConfig.getTables().stream().filter(each -> null != each.getAuditStrategy()).forEach(each -> result.addAll(each.getAuditStrategy().getAuditorNames()));
        shardingRuleConfig.getAutoTables().stream().filter(each -> null != each.getAuditStrategy()).forEach(each -> result.addAll(each.getAuditStrategy().getAuditorNames()));
        ShardingAuditStrategyConfiguration auditStrategy = shardingRuleConfig.getDefaultAuditStrategy();
        if (null != auditStrategy && !auditStrategy.getAuditorNames().isEmpty()) {
            result.addAll(auditStrategy.getAuditorNames());
        }
        return result;
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("name", "type", "props");
    }

    public Class<ShowUnusedShardingAuditorsStatement> getType() {
        return ShowUnusedShardingAuditorsStatement.class;
    }
}

