/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.query;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.shardingsphere.distsql.handler.query.RQLExecutor;
import org.apache.shardingsphere.infra.config.algorithm.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.props.PropertiesConverter;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.keygen.KeyGenerateStrategyConfiguration;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowUnusedShardingKeyGeneratorsStatement;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

public final class ShowUnusedShardingKeyGeneratorExecutor
implements RQLExecutor<ShowUnusedShardingKeyGeneratorsStatement> {
    public Collection<LocalDataQueryResultRow> getRows(ShardingSphereDatabase database, ShowUnusedShardingKeyGeneratorsStatement sqlStatement) {
        Optional rule = database.getRuleMetaData().findSingleRule(ShardingRule.class);
        if (!rule.isPresent()) {
            return Collections.emptyList();
        }
        ShardingRuleConfiguration shardingRuleConfig = (ShardingRuleConfiguration)((ShardingRule)rule.get()).getConfiguration();
        LinkedList<LocalDataQueryResultRow> result = new LinkedList<LocalDataQueryResultRow>();
        Collection<String> inUsedKeyGenerators = this.getUsedKeyGenerators(shardingRuleConfig);
        for (Map.Entry entry : shardingRuleConfig.getKeyGenerators().entrySet()) {
            if (inUsedKeyGenerators.contains(entry.getKey())) continue;
            result.add(new LocalDataQueryResultRow(new Object[]{entry.getKey(), ((AlgorithmConfiguration)entry.getValue()).getType(), this.buildProps(((AlgorithmConfiguration)entry.getValue()).getProps())}));
        }
        return result;
    }

    private Collection<String> getUsedKeyGenerators(ShardingRuleConfiguration shardingRuleConfig) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        shardingRuleConfig.getTables().stream().filter(each -> null != each.getKeyGenerateStrategy()).forEach(each -> result.add(each.getKeyGenerateStrategy().getKeyGeneratorName()));
        shardingRuleConfig.getAutoTables().stream().filter(each -> null != each.getKeyGenerateStrategy()).forEach(each -> result.add(each.getKeyGenerateStrategy().getKeyGeneratorName()));
        KeyGenerateStrategyConfiguration keyGenerateStrategy = shardingRuleConfig.getDefaultKeyGenerateStrategy();
        if (null != keyGenerateStrategy && !Strings.isNullOrEmpty((String)keyGenerateStrategy.getKeyGeneratorName())) {
            result.add(keyGenerateStrategy.getKeyGeneratorName());
        }
        return result;
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("name", "type", "props");
    }

    private String buildProps(Properties props) {
        return null == props ? "" : PropertiesConverter.convert((Properties)props);
    }

    public Class<ShowUnusedShardingKeyGeneratorsStatement> getType() {
        return ShowUnusedShardingKeyGeneratorsStatement.class;
    }
}

