/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import java.util.Optional;
import org.apache.shardingsphere.distsql.handler.exception.algorithm.InvalidAlgorithmConfigurationException;
import org.apache.shardingsphere.distsql.handler.exception.algorithm.MissingRequiredAlgorithmException;
import org.apache.shardingsphere.distsql.handler.exception.rule.MissingRequiredRuleException;
import org.apache.shardingsphere.distsql.handler.update.RuleDefinitionAlterUpdater;
import org.apache.shardingsphere.distsql.parser.segment.AlgorithmSegment;
import org.apache.shardingsphere.infra.config.algorithm.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.NoneShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.distsql.handler.converter.ShardingTableRuleStatementConverter;
import org.apache.shardingsphere.sharding.distsql.handler.enums.ShardingStrategyLevelType;
import org.apache.shardingsphere.sharding.distsql.handler.enums.ShardingStrategyType;
import org.apache.shardingsphere.sharding.distsql.parser.statement.AlterDefaultShardingStrategyStatement;

public final class AlterDefaultShardingStrategyStatementUpdater
implements RuleDefinitionAlterUpdater<AlterDefaultShardingStrategyStatement, ShardingRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereDatabase database, AlterDefaultShardingStrategyStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        String databaseName = database.getName();
        this.checkCurrentRuleConfiguration(databaseName, currentRuleConfig);
        if (!"none".equalsIgnoreCase(sqlStatement.getStrategyType())) {
            this.checkAlgorithm(sqlStatement);
        }
        this.checkExist(databaseName, sqlStatement, currentRuleConfig);
    }

    private void checkCurrentRuleConfiguration(String databaseName, ShardingRuleConfiguration currentRuleConfig) {
        ShardingSpherePreconditions.checkNotNull((Object)currentRuleConfig, () -> new MissingRequiredRuleException("Sharding", databaseName));
    }

    private void checkAlgorithm(AlterDefaultShardingStrategyStatement sqlStatement) {
        ShardingSpherePreconditions.checkState((boolean)ShardingStrategyType.contains(sqlStatement.getStrategyType()), () -> new InvalidAlgorithmConfigurationException(sqlStatement.getStrategyType()));
        ShardingSpherePreconditions.checkState((boolean)ShardingStrategyType.getValueOf(sqlStatement.getStrategyType()).isValid(sqlStatement.getShardingColumn()), () -> new InvalidAlgorithmConfigurationException(sqlStatement.getStrategyType()));
        ShardingSpherePreconditions.checkState((boolean)this.isAlgorithmDefinitionExists(sqlStatement), MissingRequiredAlgorithmException::new);
    }

    private boolean isAlgorithmDefinitionExists(AlterDefaultShardingStrategyStatement sqlStatement) {
        return null != sqlStatement.getAlgorithmSegment();
    }

    private void checkExist(String databaseName, AlterDefaultShardingStrategyStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        Optional<ShardingStrategyConfiguration> strategyConfig = this.getStrategyConfiguration(currentRuleConfig, sqlStatement.getDefaultType());
        ShardingSpherePreconditions.checkState((boolean)strategyConfig.isPresent(), () -> new MissingRequiredRuleException(String.format("Default sharding %s strategy", sqlStatement.getDefaultType().toLowerCase()), databaseName));
    }

    private Optional<ShardingStrategyConfiguration> getStrategyConfiguration(ShardingRuleConfiguration currentRuleConfig, String type) {
        ShardingStrategyConfiguration result = type.equalsIgnoreCase(ShardingStrategyLevelType.TABLE.name()) ? currentRuleConfig.getDefaultTableShardingStrategy() : currentRuleConfig.getDefaultDatabaseShardingStrategy();
        return Optional.ofNullable(result);
    }

    public ShardingRuleConfiguration buildToBeAlteredRuleConfiguration(AlterDefaultShardingStrategyStatement sqlStatement) {
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        if ("none".equalsIgnoreCase(sqlStatement.getStrategyType())) {
            this.setStrategyConfiguration(result, sqlStatement.getDefaultType(), (ShardingStrategyConfiguration)new NoneShardingStrategyConfiguration());
        } else {
            String shardingAlgorithmName = this.getShardingAlgorithmName(sqlStatement, result);
            ShardingStrategyConfiguration strategyConfig = ShardingTableRuleStatementConverter.createStrategyConfiguration(sqlStatement.getStrategyType(), sqlStatement.getShardingColumn(), shardingAlgorithmName);
            this.setStrategyConfiguration(result, sqlStatement.getDefaultType(), strategyConfig);
        }
        return result;
    }

    private String getShardingAlgorithmName(AlterDefaultShardingStrategyStatement sqlStatement, ShardingRuleConfiguration shardingRuleConfig) {
        return this.createDefaultAlgorithm(sqlStatement, shardingRuleConfig);
    }

    private String createDefaultAlgorithm(AlterDefaultShardingStrategyStatement sqlStatement, ShardingRuleConfiguration shardingRuleConfig) {
        String result = this.getDefaultShardingAlgorithmName(sqlStatement.getDefaultType(), sqlStatement.getAlgorithmSegment().getName());
        shardingRuleConfig.getShardingAlgorithms().put(result, this.createAlgorithmConfiguration(sqlStatement.getAlgorithmSegment()));
        return result;
    }

    private AlgorithmConfiguration createAlgorithmConfiguration(AlgorithmSegment segment) {
        return new AlgorithmConfiguration(segment.getName(), segment.getProps());
    }

    private String getDefaultShardingAlgorithmName(String defaultType, String algorithmType) {
        return String.format("default_%s_%s", defaultType, algorithmType).toLowerCase();
    }

    private void setStrategyConfiguration(ShardingRuleConfiguration ruleConfig, String type, ShardingStrategyConfiguration shardingStrategyConfig) {
        if (type.equalsIgnoreCase(ShardingStrategyLevelType.TABLE.name())) {
            ruleConfig.setDefaultTableShardingStrategy(shardingStrategyConfig);
        } else {
            ruleConfig.setDefaultDatabaseShardingStrategy(shardingStrategyConfig);
        }
    }

    public void updateCurrentRuleConfiguration(ShardingRuleConfiguration currentRuleConfig, ShardingRuleConfiguration toBeAlteredRuleConfig) {
        if (!toBeAlteredRuleConfig.getShardingAlgorithms().isEmpty()) {
            currentRuleConfig.getShardingAlgorithms().putAll(toBeAlteredRuleConfig.getShardingAlgorithms());
        }
        if (null != toBeAlteredRuleConfig.getDefaultTableShardingStrategy()) {
            currentRuleConfig.setDefaultTableShardingStrategy(toBeAlteredRuleConfig.getDefaultTableShardingStrategy());
        }
        if (null != toBeAlteredRuleConfig.getDefaultDatabaseShardingStrategy()) {
            currentRuleConfig.setDefaultDatabaseShardingStrategy(toBeAlteredRuleConfig.getDefaultDatabaseShardingStrategy());
        }
    }

    public Class<ShardingRuleConfiguration> getRuleConfigurationClass() {
        return ShardingRuleConfiguration.class;
    }

    public Class<AlterDefaultShardingStrategyStatement> getType() {
        return AlterDefaultShardingStrategyStatement.class;
    }
}

