/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.handler.exception.rule.DuplicateRuleException;
import org.apache.shardingsphere.distsql.handler.exception.rule.InvalidRuleConfigurationException;
import org.apache.shardingsphere.distsql.handler.exception.rule.MissingRequiredRuleException;
import org.apache.shardingsphere.distsql.handler.update.RuleDefinitionAlterUpdater;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableReferenceRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.distsql.handler.checker.ShardingTableRuleStatementChecker;
import org.apache.shardingsphere.sharding.distsql.parser.segment.table.TableReferenceRuleSegment;
import org.apache.shardingsphere.sharding.distsql.parser.statement.AlterShardingTableReferenceRuleStatement;

public final class AlterShardingTableReferenceRuleStatementUpdater
implements RuleDefinitionAlterUpdater<AlterShardingTableReferenceRuleStatement, ShardingRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereDatabase database, AlterShardingTableReferenceRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        String databaseName = database.getName();
        this.checkCurrentRuleConfiguration(databaseName, currentRuleConfig);
        this.checkToBeAlteredRulesExisted(databaseName, sqlStatement, currentRuleConfig);
        this.checkDuplicatedTablesInShardingTableReferenceRules(databaseName, sqlStatement, currentRuleConfig);
        this.checkToBeReferencedShardingTablesExisted(databaseName, sqlStatement, currentRuleConfig);
        this.checkShardingTableReferenceRulesValid(sqlStatement, currentRuleConfig);
    }

    private void checkCurrentRuleConfiguration(String databaseName, ShardingRuleConfiguration currentRuleConfig) {
        ShardingSpherePreconditions.checkNotNull((Object)currentRuleConfig, () -> new MissingRequiredRuleException("Sharding", databaseName));
    }

    private void checkToBeAlteredRulesExisted(String databaseName, AlterShardingTableReferenceRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        Collection currentRuleNames = currentRuleConfig.getBindingTableGroups().stream().map(ShardingTableReferenceRuleConfiguration::getName).collect(Collectors.toSet());
        Collection notExistedRuleNames = sqlStatement.getRules().stream().map(TableReferenceRuleSegment::getName).filter(each -> !currentRuleNames.contains(each)).collect(Collectors.toSet());
        ShardingSpherePreconditions.checkState((boolean)notExistedRuleNames.isEmpty(), () -> new MissingRequiredRuleException("Sharding table reference", databaseName, notExistedRuleNames));
    }

    private void checkDuplicatedTablesInShardingTableReferenceRules(String databaseName, AlterShardingTableReferenceRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        Collection<String> currentReferencedTableNames = this.getReferencedTableNames(currentRuleConfig, this.getToBeAlteredRuleNames(sqlStatement));
        Collection duplicatedTableNames = sqlStatement.getTableNames().stream().filter(currentReferencedTableNames::contains).collect(Collectors.toSet());
        ShardingSpherePreconditions.checkState((boolean)duplicatedTableNames.isEmpty(), () -> new DuplicateRuleException("sharding table reference", databaseName, duplicatedTableNames));
    }

    private Collection<String> getToBeAlteredRuleNames(AlterShardingTableReferenceRuleStatement sqlStatement) {
        return sqlStatement.getRules().stream().map(TableReferenceRuleSegment::getName).collect(Collectors.toSet());
    }

    private Collection<String> getToBeAlteredRuleNames(ShardingRuleConfiguration ruleConfig) {
        return ruleConfig.getBindingTableGroups().stream().map(ShardingTableReferenceRuleConfiguration::getName).collect(Collectors.toSet());
    }

    private void checkToBeReferencedShardingTablesExisted(String databaseName, AlterShardingTableReferenceRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        Collection<String> existedShardingTables = this.getCurrentShardingTables(currentRuleConfig);
        Collection notExistedShardingTables = sqlStatement.getTableNames().stream().filter(each -> !this.containsIgnoreCase(existedShardingTables, (String)each)).collect(Collectors.toSet());
        ShardingSpherePreconditions.checkState((boolean)notExistedShardingTables.isEmpty(), () -> new MissingRequiredRuleException("Sharding", databaseName, notExistedShardingTables));
    }

    private void checkShardingTableReferenceRulesValid(AlterShardingTableReferenceRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        Collection toBeAlteredShardingTableReferenceRules = this.buildToBeAlteredRuleConfiguration(sqlStatement).getBindingTableGroups();
        Collection ruleNames = toBeAlteredShardingTableReferenceRules.stream().map(ShardingTableReferenceRuleConfiguration::getName).collect(Collectors.toList());
        ShardingSpherePreconditions.checkState((boolean)ShardingTableRuleStatementChecker.isValidBindingTableGroups(toBeAlteredShardingTableReferenceRules, currentRuleConfig), () -> new InvalidRuleConfigurationException("sharding table", ruleNames, Collections.singleton("invalid sharding table reference.")));
    }

    private Collection<String> getReferencedTableNames(ShardingRuleConfiguration currentRuleConfig, Collection<String> getToBeAlteredRuleNames) {
        HashSet<String> result = new HashSet<String>();
        currentRuleConfig.getBindingTableGroups().forEach(each -> {
            if (!getToBeAlteredRuleNames.contains(each.getName())) {
                result.addAll(Arrays.stream(each.getReference().split(",")).map(String::trim).collect(Collectors.toSet()));
            }
        });
        return result;
    }

    private Collection<String> getCurrentShardingTables(ShardingRuleConfiguration currentRuleConfig) {
        HashSet<String> result = new HashSet<String>();
        result.addAll(currentRuleConfig.getTables().stream().map(ShardingTableRuleConfiguration::getLogicTable).collect(Collectors.toSet()));
        result.addAll(currentRuleConfig.getAutoTables().stream().map(ShardingAutoTableRuleConfiguration::getLogicTable).collect(Collectors.toSet()));
        return result;
    }

    private boolean containsIgnoreCase(Collection<String> currentRules, String ruleName) {
        return currentRules.stream().anyMatch(each -> each.equalsIgnoreCase(ruleName));
    }

    public ShardingRuleConfiguration buildToBeAlteredRuleConfiguration(AlterShardingTableReferenceRuleStatement sqlStatement) {
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        sqlStatement.getRules().forEach(each -> result.getBindingTableGroups().add(new ShardingTableReferenceRuleConfiguration(each.getName(), each.getReference())));
        return result;
    }

    public void updateCurrentRuleConfiguration(ShardingRuleConfiguration currentRuleConfig, ShardingRuleConfiguration toBeAlteredRuleConfig) {
        Collection<String> toBeAlteredRuleNames = this.getToBeAlteredRuleNames(toBeAlteredRuleConfig);
        currentRuleConfig.getBindingTableGroups().removeIf(each -> toBeAlteredRuleNames.contains(each.getName()));
        currentRuleConfig.getBindingTableGroups().addAll(toBeAlteredRuleConfig.getBindingTableGroups());
    }

    public Class<ShardingRuleConfiguration> getRuleConfigurationClass() {
        return ShardingRuleConfiguration.class;
    }

    public Class<AlterShardingTableReferenceRuleStatement> getType() {
        return AlterShardingTableReferenceRuleStatement.class;
    }
}

