/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import java.util.Optional;
import org.apache.shardingsphere.distsql.handler.exception.algorithm.InvalidAlgorithmConfigurationException;
import org.apache.shardingsphere.distsql.handler.exception.algorithm.MissingRequiredAlgorithmException;
import org.apache.shardingsphere.distsql.handler.exception.rule.DuplicateRuleException;
import org.apache.shardingsphere.distsql.handler.update.RuleDefinitionCreateUpdater;
import org.apache.shardingsphere.distsql.parser.segment.AlgorithmSegment;
import org.apache.shardingsphere.infra.config.algorithm.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.NoneShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.distsql.handler.converter.ShardingTableRuleStatementConverter;
import org.apache.shardingsphere.sharding.distsql.handler.enums.ShardingStrategyLevelType;
import org.apache.shardingsphere.sharding.distsql.handler.enums.ShardingStrategyType;
import org.apache.shardingsphere.sharding.distsql.parser.statement.CreateDefaultShardingStrategyStatement;

public final class CreateDefaultShardingStrategyStatementUpdater
implements RuleDefinitionCreateUpdater<CreateDefaultShardingStrategyStatement, ShardingRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereDatabase database, CreateDefaultShardingStrategyStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        String databaseName = database.getName();
        if (!"none".equalsIgnoreCase(sqlStatement.getStrategyType())) {
            this.checkAlgorithm(sqlStatement);
        }
        if (!sqlStatement.isIfNotExists()) {
            this.checkExist(databaseName, sqlStatement, currentRuleConfig);
        }
    }

    private void checkAlgorithm(CreateDefaultShardingStrategyStatement sqlStatement) {
        ShardingSpherePreconditions.checkState((boolean)ShardingStrategyType.contains(sqlStatement.getStrategyType()), () -> new InvalidAlgorithmConfigurationException(sqlStatement.getStrategyType()));
        ShardingSpherePreconditions.checkState((boolean)ShardingStrategyType.getValueOf(sqlStatement.getStrategyType()).isValid(sqlStatement.getShardingColumn()), () -> new InvalidAlgorithmConfigurationException(sqlStatement.getStrategyType()));
        ShardingSpherePreconditions.checkState((boolean)this.isAlgorithmDefinitionExists(sqlStatement), MissingRequiredAlgorithmException::new);
    }

    private boolean isAlgorithmDefinitionExists(CreateDefaultShardingStrategyStatement sqlStatement) {
        return null != sqlStatement.getAlgorithmSegment();
    }

    private void checkExist(String databaseName, CreateDefaultShardingStrategyStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        if (null == currentRuleConfig) {
            return;
        }
        Optional<ShardingStrategyConfiguration> strategyConfig = this.getStrategyConfiguration(currentRuleConfig, sqlStatement.getDefaultType());
        ShardingSpherePreconditions.checkState((!strategyConfig.isPresent() ? 1 : 0) != 0, () -> new DuplicateRuleException(String.format("default sharding %s strategy", sqlStatement.getDefaultType().toLowerCase()), databaseName));
    }

    private Optional<ShardingStrategyConfiguration> getStrategyConfiguration(ShardingRuleConfiguration currentRuleConfig, String type) {
        ShardingStrategyConfiguration result = type.equalsIgnoreCase(ShardingStrategyLevelType.TABLE.name()) ? currentRuleConfig.getDefaultTableShardingStrategy() : currentRuleConfig.getDefaultDatabaseShardingStrategy();
        return Optional.ofNullable(result);
    }

    public ShardingRuleConfiguration buildToBeCreatedRuleConfiguration(ShardingRuleConfiguration currentRuleConfig, CreateDefaultShardingStrategyStatement sqlStatement) {
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        if ("none".equalsIgnoreCase(sqlStatement.getStrategyType())) {
            this.setStrategyConfiguration(result, sqlStatement.getDefaultType(), (ShardingStrategyConfiguration)new NoneShardingStrategyConfiguration());
        } else {
            String shardingAlgorithmName = this.getShardingAlgorithmName(sqlStatement, result);
            ShardingStrategyConfiguration strategyConfig = ShardingTableRuleStatementConverter.createStrategyConfiguration(sqlStatement.getStrategyType(), sqlStatement.getShardingColumn(), shardingAlgorithmName);
            this.setStrategyConfiguration(result, sqlStatement.getDefaultType(), strategyConfig);
        }
        return result;
    }

    private String getShardingAlgorithmName(CreateDefaultShardingStrategyStatement sqlStatement, ShardingRuleConfiguration ruleConfig) {
        return this.createDefaultAlgorithm(sqlStatement, ruleConfig);
    }

    private String createDefaultAlgorithm(CreateDefaultShardingStrategyStatement sqlStatement, ShardingRuleConfiguration ruleConfig) {
        String result = this.getDefaultShardingAlgorithmName(sqlStatement.getDefaultType(), sqlStatement.getAlgorithmSegment().getName());
        ruleConfig.getShardingAlgorithms().put(result, this.createAlgorithmConfiguration(sqlStatement.getAlgorithmSegment()));
        return result;
    }

    private AlgorithmConfiguration createAlgorithmConfiguration(AlgorithmSegment segment) {
        return new AlgorithmConfiguration(segment.getName(), segment.getProps());
    }

    private String getDefaultShardingAlgorithmName(String defaultType, String algorithmType) {
        return String.format("default_%s_%s", defaultType, algorithmType).toLowerCase();
    }

    private void setStrategyConfiguration(ShardingRuleConfiguration ruleConfig, String type, ShardingStrategyConfiguration shardingStrategyConfig) {
        if (type.equalsIgnoreCase(ShardingStrategyLevelType.TABLE.name())) {
            ruleConfig.setDefaultTableShardingStrategy(shardingStrategyConfig);
        } else {
            ruleConfig.setDefaultDatabaseShardingStrategy(shardingStrategyConfig);
        }
    }

    public void updateCurrentRuleConfiguration(ShardingRuleConfiguration currentRuleConfig, ShardingRuleConfiguration toBeCreatedRuleConfig) {
        if (null != toBeCreatedRuleConfig.getDefaultTableShardingStrategy() && null == currentRuleConfig.getDefaultTableShardingStrategy()) {
            currentRuleConfig.setDefaultTableShardingStrategy(toBeCreatedRuleConfig.getDefaultTableShardingStrategy());
            if (!toBeCreatedRuleConfig.getShardingAlgorithms().isEmpty()) {
                currentRuleConfig.getShardingAlgorithms().putAll(toBeCreatedRuleConfig.getShardingAlgorithms());
            }
        }
        if (null != toBeCreatedRuleConfig.getDefaultDatabaseShardingStrategy() && null == currentRuleConfig.getDefaultDatabaseShardingStrategy()) {
            currentRuleConfig.setDefaultDatabaseShardingStrategy(toBeCreatedRuleConfig.getDefaultDatabaseShardingStrategy());
            if (!toBeCreatedRuleConfig.getShardingAlgorithms().isEmpty()) {
                currentRuleConfig.getShardingAlgorithms().putAll(toBeCreatedRuleConfig.getShardingAlgorithms());
            }
        }
    }

    public Class<ShardingRuleConfiguration> getRuleConfigurationClass() {
        return ShardingRuleConfiguration.class;
    }

    public Class<CreateDefaultShardingStrategyStatement> getType() {
        return CreateDefaultShardingStrategyStatement.class;
    }
}

