/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.handler.exception.rule.DuplicateRuleException;
import org.apache.shardingsphere.distsql.handler.exception.rule.InvalidRuleConfigurationException;
import org.apache.shardingsphere.distsql.handler.exception.rule.MissingRequiredRuleException;
import org.apache.shardingsphere.distsql.handler.update.RuleDefinitionCreateUpdater;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableReferenceRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.distsql.handler.checker.ShardingTableRuleStatementChecker;
import org.apache.shardingsphere.sharding.distsql.parser.segment.table.TableReferenceRuleSegment;
import org.apache.shardingsphere.sharding.distsql.parser.statement.CreateShardingTableReferenceRuleStatement;

public final class CreateShardingTableReferenceRuleStatementUpdater
implements RuleDefinitionCreateUpdater<CreateShardingTableReferenceRuleStatement, ShardingRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereDatabase database, CreateShardingTableReferenceRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        String databaseName = database.getName();
        this.checkCurrentRuleConfiguration(databaseName, currentRuleConfig);
        if (!sqlStatement.isIfNotExists()) {
            this.checkDuplicatedRuleNames(databaseName, sqlStatement, currentRuleConfig);
        }
        this.checkDuplicatedTablesInShardingTableReferenceRules(databaseName, sqlStatement, currentRuleConfig);
        this.checkToBeReferencedShardingTablesExisted(databaseName, sqlStatement, currentRuleConfig);
        this.checkShardingTableReferenceRulesValid(sqlStatement, currentRuleConfig);
    }

    public ShardingRuleConfiguration buildToBeCreatedRuleConfiguration(ShardingRuleConfiguration currentRuleConfig, CreateShardingTableReferenceRuleStatement sqlStatement) {
        Collection segments = sqlStatement.getRules();
        if (sqlStatement.isIfNotExists()) {
            Collection<String> duplicatedRuleNames = this.getDuplicatedRuleNames(sqlStatement, currentRuleConfig);
            segments.removeIf(each -> duplicatedRuleNames.contains(each.getName()));
        }
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        segments.forEach(each -> result.getBindingTableGroups().add(new ShardingTableReferenceRuleConfiguration(each.getName(), each.getReference())));
        return result;
    }

    public void updateCurrentRuleConfiguration(ShardingRuleConfiguration currentRuleConfig, ShardingRuleConfiguration toBeCreatedRuleConfig) {
        currentRuleConfig.getBindingTableGroups().addAll(toBeCreatedRuleConfig.getBindingTableGroups());
    }

    private Collection<String> getDuplicatedRuleNames(CreateShardingTableReferenceRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        Collection currentRuleNames = currentRuleConfig.getBindingTableGroups().stream().map(ShardingTableReferenceRuleConfiguration::getName).collect(Collectors.toSet());
        return sqlStatement.getRules().stream().map(TableReferenceRuleSegment::getName).filter(currentRuleNames::contains).collect(Collectors.toSet());
    }

    private void checkCurrentRuleConfiguration(String databaseName, ShardingRuleConfiguration currentRuleConfig) {
        ShardingSpherePreconditions.checkNotNull((Object)currentRuleConfig, () -> new MissingRequiredRuleException("Sharding", databaseName));
    }

    private void checkDuplicatedRuleNames(String databaseName, CreateShardingTableReferenceRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        Collection<String> duplicatedRuleNames = this.getDuplicatedRuleNames(sqlStatement, currentRuleConfig);
        ShardingSpherePreconditions.checkState((boolean)duplicatedRuleNames.isEmpty(), () -> new DuplicateRuleException("sharding table reference", databaseName, duplicatedRuleNames));
    }

    private void checkDuplicatedTablesInShardingTableReferenceRules(String databaseName, CreateShardingTableReferenceRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        Collection<String> currentReferencedTableNames = this.getReferencedTableNames(currentRuleConfig);
        Collection duplicatedTableNames = sqlStatement.getTableNames().stream().filter(currentReferencedTableNames::contains).collect(Collectors.toSet());
        ShardingSpherePreconditions.checkState((boolean)duplicatedTableNames.isEmpty(), () -> new DuplicateRuleException("sharding table reference", databaseName, duplicatedTableNames));
    }

    private void checkToBeReferencedShardingTablesExisted(String databaseName, CreateShardingTableReferenceRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        Collection<String> existedShardingTables = this.getCurrentLogicTables(currentRuleConfig);
        Collection notExistedShardingTables = sqlStatement.getTableNames().stream().filter(each -> !this.containsIgnoreCase(existedShardingTables, (String)each)).collect(Collectors.toSet());
        ShardingSpherePreconditions.checkState((boolean)notExistedShardingTables.isEmpty(), () -> new MissingRequiredRuleException("Sharding", databaseName, notExistedShardingTables));
    }

    private Collection<String> getCurrentLogicTables(ShardingRuleConfiguration currentRuleConfig) {
        HashSet<String> result = new HashSet<String>();
        result.addAll(currentRuleConfig.getTables().stream().map(ShardingTableRuleConfiguration::getLogicTable).collect(Collectors.toSet()));
        result.addAll(currentRuleConfig.getAutoTables().stream().map(ShardingAutoTableRuleConfiguration::getLogicTable).collect(Collectors.toSet()));
        return result;
    }

    private void checkShardingTableReferenceRulesValid(CreateShardingTableReferenceRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        Collection bindingTableGroups = this.buildToBeCreatedRuleConfiguration(currentRuleConfig, sqlStatement).getBindingTableGroups();
        Collection names = bindingTableGroups.stream().map(ShardingTableReferenceRuleConfiguration::getName).collect(Collectors.toList());
        ShardingSpherePreconditions.checkState((boolean)ShardingTableRuleStatementChecker.isValidBindingTableGroups(bindingTableGroups, currentRuleConfig), () -> new InvalidRuleConfigurationException("sharding table", names, Collections.singleton("invalid sharding table reference.")));
    }

    private Collection<String> getReferencedTableNames(ShardingRuleConfiguration currentRuleConfig) {
        return currentRuleConfig.getBindingTableGroups().stream().flatMap(each -> Arrays.stream(each.getReference().split(","))).map(String::trim).collect(Collectors.toList());
    }

    private boolean containsIgnoreCase(Collection<String> currentRules, String ruleName) {
        return currentRules.stream().anyMatch(each -> each.equalsIgnoreCase(ruleName));
    }

    public Class<ShardingRuleConfiguration> getRuleConfigurationClass() {
        return ShardingRuleConfiguration.class;
    }

    public Class<CreateShardingTableReferenceRuleStatement> getType() {
        return CreateShardingTableReferenceRuleStatement.class;
    }
}

