/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.handler.exception.algorithm.AlgorithmInUsedException;
import org.apache.shardingsphere.distsql.handler.exception.algorithm.MissingRequiredAlgorithmException;
import org.apache.shardingsphere.distsql.handler.update.RuleDefinitionDropUpdater;
import org.apache.shardingsphere.infra.config.algorithm.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.distsql.parser.statement.DropShardingAlgorithmStatement;

public final class DropShardingAlgorithmStatementUpdater
implements RuleDefinitionDropUpdater<DropShardingAlgorithmStatement, ShardingRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereDatabase database, DropShardingAlgorithmStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        if (null == currentRuleConfig && sqlStatement.isIfExists()) {
            return;
        }
        String databaseName = database.getName();
        this.checkCurrentRuleConfiguration(databaseName, currentRuleConfig);
        this.checkToBeDroppedShardingAlgorithms(databaseName, sqlStatement, currentRuleConfig);
        this.checkShardingAlgorithmsInUsed(databaseName, sqlStatement, currentRuleConfig);
    }

    private void checkCurrentRuleConfiguration(String databaseName, ShardingRuleConfiguration currentRuleConfig) {
        ShardingSpherePreconditions.checkNotNull((Object)currentRuleConfig, () -> new MissingRequiredAlgorithmException("Sharding", databaseName));
    }

    private void checkToBeDroppedShardingAlgorithms(String databaseName, DropShardingAlgorithmStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        if (sqlStatement.isIfExists()) {
            return;
        }
        Collection<String> currentShardingAlgorithms = this.getCurrentShardingAlgorithms(currentRuleConfig);
        Collection notExistedAlgorithms = sqlStatement.getNames().stream().filter(each -> !currentShardingAlgorithms.contains(each)).collect(Collectors.toList());
        if (!notExistedAlgorithms.isEmpty()) {
            throw new MissingRequiredAlgorithmException(databaseName, notExistedAlgorithms);
        }
    }

    private void checkShardingAlgorithmsInUsed(String databaseName, DropShardingAlgorithmStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        Collection<String> allInUsed = this.getAllOfAlgorithmsInUsed(currentRuleConfig);
        Collection usedAlgorithms = sqlStatement.getNames().stream().filter(allInUsed::contains).collect(Collectors.toList());
        ShardingSpherePreconditions.checkState((boolean)usedAlgorithms.isEmpty(), () -> new AlgorithmInUsedException("Sharding", databaseName, usedAlgorithms));
    }

    private Collection<String> getAllOfAlgorithmsInUsed(ShardingRuleConfiguration shardingRuleConfig) {
        ShardingStrategyConfiguration databaseShardingStrategy;
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        shardingRuleConfig.getTables().forEach(each -> {
            if (null != each.getDatabaseShardingStrategy()) {
                result.add(each.getDatabaseShardingStrategy().getShardingAlgorithmName());
            }
            if (null != each.getTableShardingStrategy()) {
                result.add(each.getTableShardingStrategy().getShardingAlgorithmName());
            }
        });
        shardingRuleConfig.getAutoTables().stream().filter(each -> null != each.getShardingStrategy()).forEach(each -> result.add(each.getShardingStrategy().getShardingAlgorithmName()));
        ShardingStrategyConfiguration tableShardingStrategy = shardingRuleConfig.getDefaultTableShardingStrategy();
        if (null != tableShardingStrategy && !tableShardingStrategy.getShardingAlgorithmName().isEmpty()) {
            result.add(tableShardingStrategy.getShardingAlgorithmName());
        }
        if (null != (databaseShardingStrategy = shardingRuleConfig.getDefaultDatabaseShardingStrategy()) && !databaseShardingStrategy.getShardingAlgorithmName().isEmpty()) {
            result.add(databaseShardingStrategy.getShardingAlgorithmName());
        }
        return result;
    }

    private Collection<String> getCurrentShardingAlgorithms(ShardingRuleConfiguration shardingRuleConfig) {
        return shardingRuleConfig.getShardingAlgorithms().keySet();
    }

    public ShardingRuleConfiguration buildToBeDroppedRuleConfiguration(ShardingRuleConfiguration currentRuleConfig, DropShardingAlgorithmStatement sqlStatement) {
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        for (String each : sqlStatement.getNames()) {
            result.getShardingAlgorithms().put(each, (AlgorithmConfiguration)currentRuleConfig.getShardingAlgorithms().get(each));
        }
        return result;
    }

    public boolean updateCurrentRuleConfiguration(DropShardingAlgorithmStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        for (String each : sqlStatement.getNames()) {
            this.dropShardingAlgorithm(currentRuleConfig, each);
        }
        return false;
    }

    public boolean hasAnyOneToBeDropped(DropShardingAlgorithmStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        return null != currentRuleConfig && !this.getIdenticalData(this.getCurrentShardingAlgorithms(currentRuleConfig), sqlStatement.getNames()).isEmpty();
    }

    private void dropShardingAlgorithm(ShardingRuleConfiguration currentRuleConfig, String algorithmName) {
        this.getCurrentShardingAlgorithms(currentRuleConfig).removeIf(algorithmName::equalsIgnoreCase);
    }

    public Class<ShardingRuleConfiguration> getRuleConfigurationClass() {
        return ShardingRuleConfiguration.class;
    }

    public Class<DropShardingAlgorithmStatement> getType() {
        return DropShardingAlgorithmStatement.class;
    }
}

