/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.handler.exception.algorithm.AlgorithmInUsedException;
import org.apache.shardingsphere.distsql.handler.exception.algorithm.MissingRequiredAlgorithmException;
import org.apache.shardingsphere.distsql.handler.update.RuleDefinitionDropUpdater;
import org.apache.shardingsphere.infra.config.algorithm.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.audit.ShardingAuditStrategyConfiguration;
import org.apache.shardingsphere.sharding.distsql.parser.statement.DropShardingAuditorStatement;

public final class DropShardingAuditorStatementUpdater
implements RuleDefinitionDropUpdater<DropShardingAuditorStatement, ShardingRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereDatabase database, DropShardingAuditorStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        if (null == currentRuleConfig && sqlStatement.isIfExists()) {
            return;
        }
        String databaseName = database.getName();
        LinkedList<String> auditorNames = new LinkedList<String>(sqlStatement.getNames());
        this.checkExist(databaseName, auditorNames, currentRuleConfig, sqlStatement);
        this.checkInUsed(databaseName, auditorNames, currentRuleConfig);
    }

    private void checkExist(String databaseName, Collection<String> auditorNames, ShardingRuleConfiguration currentRuleConfig, DropShardingAuditorStatement sqlStatement) {
        if (sqlStatement.isIfExists()) {
            return;
        }
        Collection notExistAuditors = auditorNames.stream().filter(each -> !currentRuleConfig.getAuditors().containsKey(each)).collect(Collectors.toList());
        ShardingSpherePreconditions.checkState((boolean)notExistAuditors.isEmpty(), () -> new MissingRequiredAlgorithmException("Sharding auditor", databaseName, notExistAuditors));
    }

    private void checkInUsed(String databaseName, Collection<String> auditorNames, ShardingRuleConfiguration currentRuleConfig) {
        Collection<String> usedAuditors = this.getUsedAuditors(currentRuleConfig);
        Collection inUsedNames = auditorNames.stream().filter(usedAuditors::contains).collect(Collectors.toList());
        ShardingSpherePreconditions.checkState((boolean)inUsedNames.isEmpty(), () -> new AlgorithmInUsedException("Sharding auditor", databaseName, inUsedNames));
    }

    private Collection<String> getUsedAuditors(ShardingRuleConfiguration shardingRuleConfig) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        shardingRuleConfig.getTables().stream().filter(each -> null != each.getAuditStrategy()).forEach(each -> result.addAll(each.getAuditStrategy().getAuditorNames()));
        shardingRuleConfig.getAutoTables().stream().filter(each -> null != each.getAuditStrategy()).forEach(each -> result.addAll(each.getAuditStrategy().getAuditorNames()));
        ShardingAuditStrategyConfiguration auditStrategy = shardingRuleConfig.getDefaultAuditStrategy();
        if (null != auditStrategy && !auditStrategy.getAuditorNames().isEmpty()) {
            result.addAll(auditStrategy.getAuditorNames());
        }
        return result;
    }

    public ShardingRuleConfiguration buildToBeDroppedRuleConfiguration(ShardingRuleConfiguration currentRuleConfig, DropShardingAuditorStatement sqlStatement) {
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        for (String each : sqlStatement.getNames()) {
            result.getAuditors().put(each, (AlgorithmConfiguration)currentRuleConfig.getAuditors().get(each));
        }
        return result;
    }

    public boolean updateCurrentRuleConfiguration(DropShardingAuditorStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        currentRuleConfig.getAuditors().keySet().removeIf(sqlStatement.getNames()::contains);
        return false;
    }

    public boolean hasAnyOneToBeDropped(DropShardingAuditorStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        return null != currentRuleConfig && !this.getIdenticalData(currentRuleConfig.getAuditors().keySet(), sqlStatement.getNames()).isEmpty();
    }

    public Class<ShardingRuleConfiguration> getRuleConfigurationClass() {
        return ShardingRuleConfiguration.class;
    }

    public Class<DropShardingAuditorStatement> getType() {
        return DropShardingAuditorStatement.class;
    }
}

