/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.handler.exception.algorithm.AlgorithmInUsedException;
import org.apache.shardingsphere.distsql.handler.exception.algorithm.MissingRequiredAlgorithmException;
import org.apache.shardingsphere.distsql.handler.update.RuleDefinitionDropUpdater;
import org.apache.shardingsphere.infra.config.algorithm.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.keygen.KeyGenerateStrategyConfiguration;
import org.apache.shardingsphere.sharding.distsql.parser.statement.DropShardingKeyGeneratorStatement;

public final class DropShardingKeyGeneratorStatementUpdater
implements RuleDefinitionDropUpdater<DropShardingKeyGeneratorStatement, ShardingRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereDatabase database, DropShardingKeyGeneratorStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        if (null == currentRuleConfig && sqlStatement.isIfExists()) {
            return;
        }
        String databaseName = database.getName();
        LinkedList<String> keyGeneratorNames = new LinkedList<String>(sqlStatement.getNames());
        this.checkExist(databaseName, keyGeneratorNames, currentRuleConfig, sqlStatement);
        this.checkInUsed(databaseName, keyGeneratorNames, currentRuleConfig);
    }

    private void checkExist(String databaseName, Collection<String> keyGeneratorNames, ShardingRuleConfiguration currentRuleConfig, DropShardingKeyGeneratorStatement sqlStatement) {
        if (sqlStatement.isIfExists()) {
            return;
        }
        Collection notExistKeyGenerators = keyGeneratorNames.stream().filter(each -> !currentRuleConfig.getKeyGenerators().containsKey(each)).collect(Collectors.toList());
        ShardingSpherePreconditions.checkState((boolean)notExistKeyGenerators.isEmpty(), () -> new MissingRequiredAlgorithmException("Key generator", databaseName, notExistKeyGenerators));
    }

    private void checkInUsed(String databaseName, Collection<String> keyGeneratorNames, ShardingRuleConfiguration currentRuleConfig) {
        Collection<String> usedKeyGenerators = this.getUsedKeyGenerators(currentRuleConfig);
        Collection inUsedNames = keyGeneratorNames.stream().filter(usedKeyGenerators::contains).collect(Collectors.toList());
        ShardingSpherePreconditions.checkState((boolean)inUsedNames.isEmpty(), () -> new AlgorithmInUsedException("Key generator", databaseName, inUsedNames));
    }

    private Collection<String> getUsedKeyGenerators(ShardingRuleConfiguration shardingRuleConfig) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        shardingRuleConfig.getTables().stream().filter(each -> null != each.getKeyGenerateStrategy()).forEach(each -> result.add(each.getKeyGenerateStrategy().getKeyGeneratorName()));
        shardingRuleConfig.getAutoTables().stream().filter(each -> null != each.getKeyGenerateStrategy()).forEach(each -> result.add(each.getKeyGenerateStrategy().getKeyGeneratorName()));
        KeyGenerateStrategyConfiguration keyGenerateStrategy = shardingRuleConfig.getDefaultKeyGenerateStrategy();
        if (null != keyGenerateStrategy && !Strings.isNullOrEmpty((String)keyGenerateStrategy.getKeyGeneratorName())) {
            result.add(keyGenerateStrategy.getKeyGeneratorName());
        }
        return result;
    }

    public ShardingRuleConfiguration buildToBeDroppedRuleConfiguration(ShardingRuleConfiguration currentRuleConfig, DropShardingKeyGeneratorStatement sqlStatement) {
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        for (String each : sqlStatement.getNames()) {
            result.getKeyGenerators().put(each, (AlgorithmConfiguration)currentRuleConfig.getKeyGenerators().get(each));
        }
        return result;
    }

    public boolean updateCurrentRuleConfiguration(DropShardingKeyGeneratorStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        currentRuleConfig.getKeyGenerators().keySet().removeIf(sqlStatement.getNames()::contains);
        return false;
    }

    public boolean hasAnyOneToBeDropped(DropShardingKeyGeneratorStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        return null != currentRuleConfig && !this.getIdenticalData(currentRuleConfig.getKeyGenerators().keySet(), sqlStatement.getNames()).isEmpty();
    }

    public Class<ShardingRuleConfiguration> getRuleConfigurationClass() {
        return ShardingRuleConfiguration.class;
    }

    public Class<DropShardingKeyGeneratorStatement> getType() {
        return DropShardingKeyGeneratorStatement.class;
    }
}

