/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.handler.exception.rule.MissingRequiredRuleException;
import org.apache.shardingsphere.distsql.handler.update.RuleDefinitionDropUpdater;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableReferenceRuleConfiguration;
import org.apache.shardingsphere.sharding.distsql.parser.statement.DropShardingTableReferenceRuleStatement;

public final class DropShardingTableReferenceRuleStatementUpdater
implements RuleDefinitionDropUpdater<DropShardingTableReferenceRuleStatement, ShardingRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereDatabase database, DropShardingTableReferenceRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        if (!this.isExistRuleConfig((RuleConfiguration)currentRuleConfig) && sqlStatement.isIfExists()) {
            return;
        }
        String databaseName = database.getName();
        this.checkCurrentRuleConfiguration(databaseName, currentRuleConfig);
        this.checkToBeDroppedShardingTableReferenceRules(databaseName, sqlStatement, currentRuleConfig);
    }

    private void checkCurrentRuleConfiguration(String databaseName, ShardingRuleConfiguration currentRuleConfig) {
        ShardingSpherePreconditions.checkState((null != currentRuleConfig && !currentRuleConfig.getBindingTableGroups().isEmpty() ? 1 : 0) != 0, () -> new MissingRequiredRuleException("Sharding table reference", databaseName));
    }

    private void checkToBeDroppedShardingTableReferenceRules(String databaseName, DropShardingTableReferenceRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        if (sqlStatement.isIfExists()) {
            return;
        }
        Collection<String> currentRuleNames = this.getCurrentShardingTableReferenceRuleNames(currentRuleConfig);
        Collection notExistedRuleNames = sqlStatement.getNames().stream().filter(each -> !this.containsIgnoreCase(currentRuleNames, (String)each)).collect(Collectors.toList());
        ShardingSpherePreconditions.checkState((boolean)notExistedRuleNames.isEmpty(), () -> new MissingRequiredRuleException("Sharding table reference", databaseName, notExistedRuleNames));
    }

    private Collection<String> getCurrentShardingTableReferenceRuleNames(ShardingRuleConfiguration currentRuleConfig) {
        return currentRuleConfig.getBindingTableGroups().stream().map(ShardingTableReferenceRuleConfiguration::getName).collect(Collectors.toList());
    }

    private boolean containsIgnoreCase(Collection<String> ruleNames, String name) {
        return ruleNames.stream().anyMatch(each -> each.equalsIgnoreCase(name));
    }

    public ShardingRuleConfiguration buildToBeDroppedRuleConfiguration(ShardingRuleConfiguration currentRuleConfig, DropShardingTableReferenceRuleStatement sqlStatement) {
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        for (String each : sqlStatement.getNames()) {
            result.getBindingTableGroups().add(new ShardingTableReferenceRuleConfiguration(each, ""));
        }
        return result;
    }

    public boolean updateCurrentRuleConfiguration(DropShardingTableReferenceRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        currentRuleConfig.getBindingTableGroups().removeIf(each -> sqlStatement.getNames().stream().anyMatch(each.getName()::equalsIgnoreCase));
        return false;
    }

    public boolean hasAnyOneToBeDropped(DropShardingTableReferenceRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        return this.isExistRuleConfig((RuleConfiguration)currentRuleConfig) && !this.getIdenticalData(this.getCurrentShardingTableReferenceRuleNames(currentRuleConfig), sqlStatement.getNames()).isEmpty();
    }

    public Class<ShardingRuleConfiguration> getRuleConfigurationClass() {
        return ShardingRuleConfiguration.class;
    }

    public Class<DropShardingTableReferenceRuleStatement> getType() {
        return DropShardingTableReferenceRuleStatement.class;
    }
}

