/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.handler.exception.rule.MissingRequiredRuleException;
import org.apache.shardingsphere.distsql.handler.exception.rule.RuleInUsedException;
import org.apache.shardingsphere.distsql.handler.update.RuleDefinitionDropUpdater;
import org.apache.shardingsphere.infra.config.algorithm.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.keygen.KeyGenerateStrategyConfiguration;
import org.apache.shardingsphere.sharding.distsql.handler.update.UnusedAlgorithmFinder;
import org.apache.shardingsphere.sharding.distsql.parser.statement.DropShardingTableRuleStatement;

public final class DropShardingTableRuleStatementUpdater
implements RuleDefinitionDropUpdater<DropShardingTableRuleStatement, ShardingRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereDatabase database, DropShardingTableRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        if (!this.isExistRuleConfig((RuleConfiguration)currentRuleConfig) && sqlStatement.isIfExists()) {
            return;
        }
        String databaseName = database.getName();
        this.checkCurrentRuleConfiguration(databaseName, currentRuleConfig);
        this.checkToBeDroppedShardingTableNames(databaseName, sqlStatement, currentRuleConfig);
        this.checkBindingTables(databaseName, sqlStatement, currentRuleConfig);
    }

    private void checkCurrentRuleConfiguration(String databaseName, ShardingRuleConfiguration currentRuleConfig) {
        ShardingSpherePreconditions.checkNotNull((Object)currentRuleConfig, () -> new MissingRequiredRuleException("Sharding", databaseName));
    }

    private Collection<String> getToBeDroppedShardingTableNames(DropShardingTableRuleStatement sqlStatement) {
        return sqlStatement.getTableNames().stream().map(each -> each.getIdentifier().getValue()).collect(Collectors.toList());
    }

    private void checkToBeDroppedShardingTableNames(String databaseName, DropShardingTableRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        if (sqlStatement.isIfExists()) {
            return;
        }
        Collection<String> currentShardingTableNames = this.getCurrentShardingTableNames(currentRuleConfig);
        Collection notExistedTableNames = this.getToBeDroppedShardingTableNames(sqlStatement).stream().filter(each -> !this.containsIgnoreCase(currentShardingTableNames, (String)each)).collect(Collectors.toList());
        ShardingSpherePreconditions.checkState((boolean)notExistedTableNames.isEmpty(), () -> new MissingRequiredRuleException("sharding", databaseName, notExistedTableNames));
    }

    private boolean containsIgnoreCase(Collection<String> collection, String str) {
        return collection.stream().anyMatch(each -> each.equalsIgnoreCase(str));
    }

    private Collection<String> getCurrentShardingTableNames(ShardingRuleConfiguration shardingRuleConfig) {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(shardingRuleConfig.getTables().stream().map(ShardingTableRuleConfiguration::getLogicTable).collect(Collectors.toList()));
        result.addAll(shardingRuleConfig.getAutoTables().stream().map(ShardingAutoTableRuleConfiguration::getLogicTable).collect(Collectors.toList()));
        return result;
    }

    private void checkBindingTables(String databaseName, DropShardingTableRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        Collection<String> bindingTables = this.getBindingTables(currentRuleConfig);
        Collection usedTableNames = this.getToBeDroppedShardingTableNames(sqlStatement).stream().filter(each -> this.containsIgnoreCase(bindingTables, (String)each)).collect(Collectors.toList());
        if (!usedTableNames.isEmpty()) {
            throw new RuleInUsedException("Sharding", databaseName, usedTableNames, "sharding table reference");
        }
    }

    private Collection<String> getBindingTables(ShardingRuleConfiguration shardingRuleConfig) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        shardingRuleConfig.getBindingTableGroups().forEach(each -> result.addAll(Splitter.on((String)",").splitToList((CharSequence)each.getReference())));
        return result;
    }

    public boolean hasAnyOneToBeDropped(DropShardingTableRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        if (null == currentRuleConfig) {
            return false;
        }
        LinkedList currentTableNames = new LinkedList();
        currentTableNames.addAll(currentRuleConfig.getTables().stream().map(ShardingTableRuleConfiguration::getLogicTable).collect(Collectors.toSet()));
        currentTableNames.addAll(currentRuleConfig.getAutoTables().stream().map(ShardingAutoTableRuleConfiguration::getLogicTable).collect(Collectors.toSet()));
        return !this.getIdenticalData(currentTableNames, sqlStatement.getTableNames().stream().map(each -> each.getIdentifier().getValue()).collect(Collectors.toSet())).isEmpty();
    }

    public ShardingRuleConfiguration buildToBeDroppedRuleConfiguration(ShardingRuleConfiguration currentRuleConfig, DropShardingTableRuleStatement sqlStatement) {
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        Collection<String> toBeDroppedShardingTableNames = this.getToBeDroppedShardingTableNames(sqlStatement);
        for (String each2 : toBeDroppedShardingTableNames) {
            result.getTables().addAll(currentRuleConfig.getTables().stream().filter(table -> each2.equalsIgnoreCase(table.getLogicTable())).collect(Collectors.toList()));
            result.getAutoTables().addAll(currentRuleConfig.getAutoTables().stream().filter(table -> each2.equalsIgnoreCase(table.getLogicTable())).collect(Collectors.toList()));
            this.dropShardingTable(currentRuleConfig, each2);
        }
        UnusedAlgorithmFinder.find(currentRuleConfig).forEach(each -> result.getShardingAlgorithms().put(each, (AlgorithmConfiguration)currentRuleConfig.getShardingAlgorithms().get(each)));
        DropShardingTableRuleStatementUpdater.findUnusedKeyGenerator(currentRuleConfig).forEach(each -> result.getKeyGenerators().put(each, (AlgorithmConfiguration)currentRuleConfig.getKeyGenerators().get(each)));
        DropShardingTableRuleStatementUpdater.findUnusedAuditors(currentRuleConfig).forEach(each -> result.getAuditors().put(each, (AlgorithmConfiguration)currentRuleConfig.getAuditors().get(each)));
        return result;
    }

    public boolean updateCurrentRuleConfiguration(DropShardingTableRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        Collection<String> toBeDroppedShardingTableNames = this.getToBeDroppedShardingTableNames(sqlStatement);
        toBeDroppedShardingTableNames.forEach(each -> this.dropShardingTable(currentRuleConfig, (String)each));
        UnusedAlgorithmFinder.find(currentRuleConfig).forEach(each -> currentRuleConfig.getShardingAlgorithms().remove(each));
        this.dropUnusedKeyGenerator(currentRuleConfig);
        this.dropUnusedAuditor(currentRuleConfig);
        return currentRuleConfig.isEmpty();
    }

    private void dropShardingTable(ShardingRuleConfiguration currentRuleConfig, String tableName) {
        currentRuleConfig.getTables().removeAll(currentRuleConfig.getTables().stream().filter(each -> tableName.equalsIgnoreCase(each.getLogicTable())).collect(Collectors.toList()));
        currentRuleConfig.getAutoTables().removeAll(currentRuleConfig.getAutoTables().stream().filter(each -> tableName.equalsIgnoreCase(each.getLogicTable())).collect(Collectors.toList()));
    }

    private void dropUnusedKeyGenerator(ShardingRuleConfiguration currentRuleConfig) {
        DropShardingTableRuleStatementUpdater.findUnusedKeyGenerator(currentRuleConfig).forEach(each -> currentRuleConfig.getKeyGenerators().remove(each));
    }

    private static Collection<String> findUnusedKeyGenerator(ShardingRuleConfiguration currentRuleConfig) {
        Collection inUsedKeyGenerators = currentRuleConfig.getTables().stream().map(ShardingTableRuleConfiguration::getKeyGenerateStrategy).filter(Objects::nonNull).map(KeyGenerateStrategyConfiguration::getKeyGeneratorName).collect(Collectors.toSet());
        inUsedKeyGenerators.addAll(currentRuleConfig.getAutoTables().stream().map(ShardingAutoTableRuleConfiguration::getKeyGenerateStrategy).filter(Objects::nonNull).map(KeyGenerateStrategyConfiguration::getKeyGeneratorName).collect(Collectors.toSet()));
        if (null != currentRuleConfig.getDefaultKeyGenerateStrategy()) {
            inUsedKeyGenerators.add(currentRuleConfig.getDefaultKeyGenerateStrategy().getKeyGeneratorName());
        }
        return currentRuleConfig.getKeyGenerators().keySet().stream().filter(each -> !inUsedKeyGenerators.contains(each)).collect(Collectors.toSet());
    }

    private void dropUnusedAuditor(ShardingRuleConfiguration currentRuleConfig) {
        DropShardingTableRuleStatementUpdater.findUnusedAuditors(currentRuleConfig).forEach(each -> currentRuleConfig.getAuditors().remove(each));
    }

    private static Collection<String> findUnusedAuditors(ShardingRuleConfiguration currentRuleConfig) {
        Collection inUsedAuditors = currentRuleConfig.getTables().stream().map(ShardingTableRuleConfiguration::getAuditStrategy).filter(Objects::nonNull).flatMap(each -> each.getAuditorNames().stream()).collect(Collectors.toSet());
        inUsedAuditors.addAll(currentRuleConfig.getAutoTables().stream().map(ShardingAutoTableRuleConfiguration::getAuditStrategy).filter(Objects::nonNull).flatMap(each -> each.getAuditorNames().stream()).collect(Collectors.toSet()));
        if (null != currentRuleConfig.getDefaultAuditStrategy()) {
            inUsedAuditors.addAll(currentRuleConfig.getDefaultAuditStrategy().getAuditorNames());
        }
        return currentRuleConfig.getAuditors().keySet().stream().filter(each -> !inUsedAuditors.contains(each)).collect(Collectors.toSet());
    }

    public Class<ShardingRuleConfiguration> getRuleConfigurationClass() {
        return ShardingRuleConfiguration.class;
    }

    public Class<DropShardingTableRuleStatement> getType() {
        return DropShardingTableRuleStatement.class;
    }
}

