/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;

public final class UnusedAlgorithmFinder {
    public static Collection<String> find(ShardingRuleConfiguration ruleConfig) {
        Collection inUsedAlgorithms = ruleConfig.getTables().stream().map(each -> Arrays.asList(each.getTableShardingStrategy(), each.getDatabaseShardingStrategy())).flatMap(Collection::stream).filter(Objects::nonNull).map(ShardingStrategyConfiguration::getShardingAlgorithmName).collect(Collectors.toSet());
        inUsedAlgorithms.addAll(ruleConfig.getTables().stream().filter(each -> null != each.getDatabaseShardingStrategy()).map(each -> each.getDatabaseShardingStrategy().getShardingAlgorithmName()).collect(Collectors.toSet()));
        inUsedAlgorithms.addAll(ruleConfig.getTables().stream().filter(each -> null != each.getTableShardingStrategy()).map(each -> each.getTableShardingStrategy().getShardingAlgorithmName()).collect(Collectors.toSet()));
        inUsedAlgorithms.addAll(ruleConfig.getAutoTables().stream().filter(each -> null != each.getShardingStrategy()).map(each -> each.getShardingStrategy().getShardingAlgorithmName()).collect(Collectors.toSet()));
        if (null != ruleConfig.getDefaultDatabaseShardingStrategy()) {
            inUsedAlgorithms.add(ruleConfig.getDefaultDatabaseShardingStrategy().getShardingAlgorithmName());
        }
        if (null != ruleConfig.getDefaultTableShardingStrategy()) {
            inUsedAlgorithms.add(ruleConfig.getDefaultTableShardingStrategy().getShardingAlgorithmName());
        }
        return ruleConfig.getShardingAlgorithms().keySet().stream().filter(each -> !inUsedAlgorithms.contains(each)).collect(Collectors.toSet());
    }

    @Generated
    private UnusedAlgorithmFinder() {
    }
}

