/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import com.cedarsoftware.util.CaseInsensitiveSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.DatabaseRuleAlterExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorCurrentRuleRequired;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.DuplicateRuleException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.InvalidRuleConfigurationException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.MissingRequiredRuleException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableReferenceRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.distsql.handler.checker.ShardingTableRuleStatementChecker;
import org.apache.shardingsphere.sharding.distsql.segment.table.TableReferenceRuleSegment;
import org.apache.shardingsphere.sharding.distsql.statement.AlterShardingTableReferenceRuleStatement;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

@DistSQLExecutorCurrentRuleRequired(value=ShardingRule.class)
public final class AlterShardingTableReferenceRuleExecutor
implements DatabaseRuleAlterExecutor<AlterShardingTableReferenceRuleStatement, ShardingRule, ShardingRuleConfiguration> {
    private ShardingSphereDatabase database;
    private ShardingRule rule;

    public void checkBeforeUpdate(AlterShardingTableReferenceRuleStatement sqlStatement) {
        this.checkToBeAlteredRulesExisted(sqlStatement);
        this.checkDuplicatedTablesInShardingTableReferenceRules(sqlStatement);
        this.checkToBeReferencedShardingTablesExisted(sqlStatement);
        this.checkShardingTableReferenceRulesValid(sqlStatement);
    }

    private void checkToBeAlteredRulesExisted(AlterShardingTableReferenceRuleStatement sqlStatement) {
        Collection currentRuleNames = this.rule.getConfiguration().getBindingTableGroups().stream().map(ShardingTableReferenceRuleConfiguration::getName).collect(Collectors.toSet());
        Collection notExistedRuleNames = sqlStatement.getRules().stream().map(TableReferenceRuleSegment::getName).filter(each -> !currentRuleNames.contains(each)).collect(Collectors.toSet());
        ShardingSpherePreconditions.checkState((boolean)notExistedRuleNames.isEmpty(), () -> new MissingRequiredRuleException("Sharding table reference", this.database.getName(), notExistedRuleNames));
    }

    private void checkDuplicatedTablesInShardingTableReferenceRules(AlterShardingTableReferenceRuleStatement sqlStatement) {
        Collection<String> currentReferencedTableNames = this.getReferencedTableNames(this.getToBeAlteredRuleNames(sqlStatement));
        Collection duplicatedTableNames = sqlStatement.getTableNames().stream().filter(currentReferencedTableNames::contains).collect(Collectors.toSet());
        ShardingSpherePreconditions.checkState((boolean)duplicatedTableNames.isEmpty(), () -> new DuplicateRuleException("sharding table reference", this.database.getName(), duplicatedTableNames));
    }

    private Collection<String> getReferencedTableNames(Collection<String> getToBeAlteredRuleNames) {
        HashSet<String> result = new HashSet<String>();
        this.rule.getConfiguration().getBindingTableGroups().forEach(each -> {
            if (!getToBeAlteredRuleNames.contains(each.getName())) {
                result.addAll(Arrays.stream(each.getReference().split(",")).map(String::trim).collect(Collectors.toSet()));
            }
        });
        return result;
    }

    private Collection<String> getToBeAlteredRuleNames(AlterShardingTableReferenceRuleStatement sqlStatement) {
        return sqlStatement.getRules().stream().map(TableReferenceRuleSegment::getName).collect(Collectors.toSet());
    }

    private void checkToBeReferencedShardingTablesExisted(AlterShardingTableReferenceRuleStatement sqlStatement) {
        Collection<String> currentShardingTableNames = this.getCurrentShardingTableNames();
        Collection notExistedTableNames = sqlStatement.getTableNames().stream().filter(each -> !currentShardingTableNames.contains(each)).collect(Collectors.toSet());
        ShardingSpherePreconditions.checkState((boolean)notExistedTableNames.isEmpty(), () -> new MissingRequiredRuleException("Sharding", this.database.getName(), notExistedTableNames));
    }

    private Collection<String> getCurrentShardingTableNames() {
        CaseInsensitiveSet result = new CaseInsensitiveSet();
        result.addAll(this.rule.getConfiguration().getTables().stream().map(ShardingTableRuleConfiguration::getLogicTable).collect(Collectors.toSet()));
        result.addAll(this.rule.getConfiguration().getAutoTables().stream().map(ShardingAutoTableRuleConfiguration::getLogicTable).collect(Collectors.toSet()));
        return result;
    }

    private void checkShardingTableReferenceRulesValid(AlterShardingTableReferenceRuleStatement sqlStatement) {
        Collection toBeAlteredShardingTableReferenceRules = this.buildToBeAlteredRuleConfiguration(sqlStatement).getBindingTableGroups();
        Collection ruleNames = toBeAlteredShardingTableReferenceRules.stream().map(ShardingTableReferenceRuleConfiguration::getName).collect(Collectors.toList());
        ShardingSpherePreconditions.checkState((boolean)ShardingTableRuleStatementChecker.isValidBindingTableGroups(toBeAlteredShardingTableReferenceRules, this.rule.getConfiguration()), () -> new InvalidRuleConfigurationException("sharding table", ruleNames, Collections.singleton("invalid sharding table reference.")));
    }

    public ShardingRuleConfiguration buildToBeAlteredRuleConfiguration(AlterShardingTableReferenceRuleStatement sqlStatement) {
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        sqlStatement.getRules().forEach(each -> result.getBindingTableGroups().add(new ShardingTableReferenceRuleConfiguration(each.getName(), each.getReference())));
        return result;
    }

    public ShardingRuleConfiguration buildToBeDroppedRuleConfiguration(ShardingRuleConfiguration toBeAlteredRuleConfig) {
        return null;
    }

    public Class<ShardingRule> getRuleClass() {
        return ShardingRule.class;
    }

    public Class<AlterShardingTableReferenceRuleStatement> getType() {
        return AlterShardingTableReferenceRuleStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }

    @Generated
    public void setRule(ShardingRule rule) {
        this.rule = rule;
    }
}

