/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.DatabaseRuleCreateExecutor;
import org.apache.shardingsphere.distsql.segment.AlgorithmSegment;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.core.exception.EmptyAlgorithmException;
import org.apache.shardingsphere.infra.algorithm.core.exception.InvalidAlgorithmConfigurationException;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.core.external.sql.identifier.SQLExceptionIdentifier;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.DuplicateRuleException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.NoneShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.distsql.handler.converter.ShardingTableRuleStatementConverter;
import org.apache.shardingsphere.sharding.distsql.handler.enums.ShardingStrategyLevelType;
import org.apache.shardingsphere.sharding.distsql.handler.enums.ShardingStrategyType;
import org.apache.shardingsphere.sharding.distsql.statement.CreateDefaultShardingStrategyStatement;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

public final class CreateDefaultShardingStrategyExecutor
implements DatabaseRuleCreateExecutor<CreateDefaultShardingStrategyStatement, ShardingRule, ShardingRuleConfiguration> {
    private ShardingSphereDatabase database;
    private ShardingRule rule;

    public void checkBeforeUpdate(CreateDefaultShardingStrategyStatement sqlStatement) {
        if (!"none".equalsIgnoreCase(sqlStatement.getStrategyType())) {
            this.checkAlgorithm(sqlStatement);
        }
        if (!sqlStatement.isIfNotExists()) {
            this.checkExist(sqlStatement);
        }
    }

    private void checkAlgorithm(CreateDefaultShardingStrategyStatement sqlStatement) {
        ShardingSpherePreconditions.checkState((boolean)ShardingStrategyType.isValidType(sqlStatement.getStrategyType()), () -> new InvalidAlgorithmConfigurationException(sqlStatement.getStrategyType()));
        ShardingSpherePreconditions.checkState((boolean)ShardingStrategyType.getValueOf(sqlStatement.getStrategyType()).isValid(sqlStatement.getShardingColumn()), () -> new InvalidAlgorithmConfigurationException(sqlStatement.getStrategyType()));
        ShardingSpherePreconditions.checkNotNull((Object)sqlStatement.getAlgorithmSegment(), () -> new EmptyAlgorithmException("Sharding", new SQLExceptionIdentifier("")));
    }

    private void checkExist(CreateDefaultShardingStrategyStatement sqlStatement) {
        if (null == this.rule) {
            return;
        }
        ShardingSpherePreconditions.checkState((!this.getStrategyConfiguration(sqlStatement.getDefaultType()).isPresent() ? 1 : 0) != 0, () -> new DuplicateRuleException(String.format("default sharding %s strategy", sqlStatement.getDefaultType().toLowerCase()), this.database.getName()));
    }

    private Optional<ShardingStrategyConfiguration> getStrategyConfiguration(String type) {
        ShardingStrategyConfiguration result = type.equalsIgnoreCase(ShardingStrategyLevelType.TABLE.name()) ? this.rule.getConfiguration().getDefaultTableShardingStrategy() : this.rule.getConfiguration().getDefaultDatabaseShardingStrategy();
        return Optional.ofNullable(result);
    }

    public ShardingRuleConfiguration buildToBeCreatedRuleConfiguration(CreateDefaultShardingStrategyStatement sqlStatement) {
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        if ("none".equalsIgnoreCase(sqlStatement.getStrategyType())) {
            this.setStrategyConfiguration(result, sqlStatement.getDefaultType(), (ShardingStrategyConfiguration)new NoneShardingStrategyConfiguration());
        } else {
            String shardingAlgorithmName = this.getShardingAlgorithmName(sqlStatement, result);
            ShardingStrategyConfiguration strategyConfig = ShardingTableRuleStatementConverter.createStrategyConfiguration(sqlStatement.getStrategyType(), sqlStatement.getShardingColumn(), shardingAlgorithmName);
            this.setStrategyConfiguration(result, sqlStatement.getDefaultType(), strategyConfig);
        }
        return result;
    }

    private String getShardingAlgorithmName(CreateDefaultShardingStrategyStatement sqlStatement, ShardingRuleConfiguration ruleConfig) {
        return this.createDefaultAlgorithm(sqlStatement, ruleConfig);
    }

    private String createDefaultAlgorithm(CreateDefaultShardingStrategyStatement sqlStatement, ShardingRuleConfiguration ruleConfig) {
        String result = this.getDefaultShardingAlgorithmName(sqlStatement.getDefaultType(), sqlStatement.getAlgorithmSegment().getName());
        ruleConfig.getShardingAlgorithms().put(result, this.createAlgorithmConfiguration(sqlStatement.getAlgorithmSegment()));
        return result;
    }

    private AlgorithmConfiguration createAlgorithmConfiguration(AlgorithmSegment segment) {
        return new AlgorithmConfiguration(segment.getName(), segment.getProps());
    }

    private String getDefaultShardingAlgorithmName(String defaultType, String algorithmType) {
        return String.format("default_%s_%s", defaultType, algorithmType).toLowerCase();
    }

    private void setStrategyConfiguration(ShardingRuleConfiguration ruleConfig, String type, ShardingStrategyConfiguration shardingStrategyConfig) {
        if (type.equalsIgnoreCase(ShardingStrategyLevelType.TABLE.name())) {
            ruleConfig.setDefaultTableShardingStrategy(shardingStrategyConfig);
        } else {
            ruleConfig.setDefaultDatabaseShardingStrategy(shardingStrategyConfig);
        }
    }

    public Class<ShardingRule> getRuleClass() {
        return ShardingRule.class;
    }

    public Class<CreateDefaultShardingStrategyStatement> getType() {
        return CreateDefaultShardingStrategyStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }

    @Generated
    public void setRule(ShardingRule rule) {
        this.rule = rule;
    }
}

