/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.DatabaseRuleDropExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorCurrentRuleRequired;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.MissingRequiredRuleException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.distsql.handler.enums.ShardingStrategyLevelType;
import org.apache.shardingsphere.sharding.distsql.handler.update.UnusedAlgorithmFinder;
import org.apache.shardingsphere.sharding.distsql.statement.DropDefaultShardingStrategyStatement;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

@DistSQLExecutorCurrentRuleRequired(value=ShardingRule.class)
public final class DropDefaultShardingStrategyExecutor
implements DatabaseRuleDropExecutor<DropDefaultShardingStrategyStatement, ShardingRule, ShardingRuleConfiguration> {
    private ShardingSphereDatabase database;
    private ShardingRule rule;

    public void checkBeforeUpdate(DropDefaultShardingStrategyStatement sqlStatement) {
        if (!sqlStatement.isIfExists()) {
            this.checkExist(sqlStatement);
        }
    }

    private void checkExist(DropDefaultShardingStrategyStatement sqlStatement) {
        Optional<ShardingStrategyConfiguration> strategyConfig = this.getStrategyConfiguration(sqlStatement.getDefaultType());
        ShardingSpherePreconditions.checkState((boolean)strategyConfig.isPresent(), () -> new MissingRequiredRuleException(String.format("Default sharding %s strategy", sqlStatement.getDefaultType().toLowerCase()), this.database.getName()));
    }

    private Optional<ShardingStrategyConfiguration> getStrategyConfiguration(String type) {
        ShardingStrategyConfiguration result = type.equalsIgnoreCase(ShardingStrategyLevelType.TABLE.name()) ? this.rule.getConfiguration().getDefaultTableShardingStrategy() : this.rule.getConfiguration().getDefaultDatabaseShardingStrategy();
        return Optional.ofNullable(result);
    }

    public boolean hasAnyOneToBeDropped(DropDefaultShardingStrategyStatement sqlStatement) {
        return sqlStatement.getDefaultType().equalsIgnoreCase(ShardingStrategyLevelType.TABLE.name()) ? null != this.rule.getConfiguration().getDefaultTableShardingStrategy() : null != this.rule.getConfiguration().getDefaultDatabaseShardingStrategy();
    }

    public ShardingRuleConfiguration buildToBeDroppedRuleConfiguration(DropDefaultShardingStrategyStatement sqlStatement) {
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        if (sqlStatement.getDefaultType().equalsIgnoreCase(ShardingStrategyLevelType.TABLE.name())) {
            result.setDefaultTableShardingStrategy(this.rule.getConfiguration().getDefaultTableShardingStrategy());
            this.rule.getConfiguration().setDefaultTableShardingStrategy(null);
        } else {
            result.setDefaultDatabaseShardingStrategy(this.rule.getConfiguration().getDefaultDatabaseShardingStrategy());
            this.rule.getConfiguration().setDefaultDatabaseShardingStrategy(null);
        }
        UnusedAlgorithmFinder.findUnusedShardingAlgorithm(this.rule.getConfiguration()).forEach(each -> result.getShardingAlgorithms().put(each, (AlgorithmConfiguration)this.rule.getConfiguration().getShardingAlgorithms().get(each)));
        return result;
    }

    public Class<ShardingRule> getRuleClass() {
        return ShardingRule.class;
    }

    public Class<DropDefaultShardingStrategyStatement> getType() {
        return DropDefaultShardingStrategyStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }

    @Generated
    public void setRule(ShardingRule rule) {
        this.rule = rule;
    }
}

