/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.DatabaseRuleDropExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorCurrentRuleRequired;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.core.exception.InUsedAlgorithmException;
import org.apache.shardingsphere.infra.algorithm.core.exception.UnregisteredAlgorithmException;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.core.external.sql.identifier.SQLExceptionIdentifier;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.audit.ShardingAuditStrategyConfiguration;
import org.apache.shardingsphere.sharding.distsql.statement.DropShardingAuditorStatement;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

@DistSQLExecutorCurrentRuleRequired(value=ShardingRule.class)
public final class DropShardingAuditorExecutor
implements DatabaseRuleDropExecutor<DropShardingAuditorStatement, ShardingRule, ShardingRuleConfiguration> {
    private ShardingSphereDatabase database;
    private ShardingRule rule;

    public void checkBeforeUpdate(DropShardingAuditorStatement sqlStatement) {
        if (!sqlStatement.isIfExists()) {
            this.checkExist(sqlStatement);
        }
        if (null != this.rule) {
            this.checkInUsed(sqlStatement);
        }
    }

    private void checkExist(DropShardingAuditorStatement sqlStatement) {
        Collection notExistAuditors = sqlStatement.getNames().stream().filter(each -> !this.rule.getConfiguration().getAuditors().containsKey(each)).collect(Collectors.toList());
        ShardingSpherePreconditions.checkState((boolean)notExistAuditors.isEmpty(), () -> new UnregisteredAlgorithmException("Sharding auditor", notExistAuditors, new SQLExceptionIdentifier(this.database.getName())));
    }

    private void checkInUsed(DropShardingAuditorStatement sqlStatement) {
        Collection<String> usedAuditors = this.getUsedAuditors();
        Collection inUsedNames = sqlStatement.getNames().stream().filter(usedAuditors::contains).collect(Collectors.toList());
        ShardingSpherePreconditions.checkState((boolean)inUsedNames.isEmpty(), () -> new InUsedAlgorithmException("Sharding auditor", this.database.getName(), inUsedNames));
    }

    private Collection<String> getUsedAuditors() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        this.rule.getConfiguration().getTables().stream().filter(each -> null != each.getAuditStrategy()).forEach(each -> result.addAll(each.getAuditStrategy().getAuditorNames()));
        this.rule.getConfiguration().getAutoTables().stream().filter(each -> null != each.getAuditStrategy()).forEach(each -> result.addAll(each.getAuditStrategy().getAuditorNames()));
        ShardingAuditStrategyConfiguration auditStrategy = this.rule.getConfiguration().getDefaultAuditStrategy();
        if (null != auditStrategy && !auditStrategy.getAuditorNames().isEmpty()) {
            result.addAll(auditStrategy.getAuditorNames());
        }
        return result;
    }

    public ShardingRuleConfiguration buildToBeDroppedRuleConfiguration(DropShardingAuditorStatement sqlStatement) {
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        for (String each : sqlStatement.getNames()) {
            result.getAuditors().put(each, (AlgorithmConfiguration)this.rule.getConfiguration().getAuditors().get(each));
        }
        return result;
    }

    public boolean hasAnyOneToBeDropped(DropShardingAuditorStatement sqlStatement) {
        return !Collections.disjoint(this.rule.getConfiguration().getAuditors().keySet(), sqlStatement.getNames());
    }

    public Class<ShardingRule> getRuleClass() {
        return ShardingRule.class;
    }

    public Class<DropShardingAuditorStatement> getType() {
        return DropShardingAuditorStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }

    @Generated
    public void setRule(ShardingRule rule) {
        this.rule = rule;
    }
}

