/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.DatabaseRuleDropExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorCurrentRuleRequired;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.core.exception.InUsedAlgorithmException;
import org.apache.shardingsphere.infra.algorithm.core.exception.UnregisteredAlgorithmException;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.core.external.sql.identifier.SQLExceptionIdentifier;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.keygen.KeyGenerateStrategyConfiguration;
import org.apache.shardingsphere.sharding.distsql.statement.DropShardingKeyGeneratorStatement;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

@DistSQLExecutorCurrentRuleRequired(value=ShardingRule.class)
public final class DropShardingKeyGeneratorExecutor
implements DatabaseRuleDropExecutor<DropShardingKeyGeneratorStatement, ShardingRule, ShardingRuleConfiguration> {
    private ShardingSphereDatabase database;
    private ShardingRule rule;

    public void checkBeforeUpdate(DropShardingKeyGeneratorStatement sqlStatement) {
        if (!sqlStatement.isIfExists()) {
            this.checkExist(sqlStatement);
        }
        if (null != this.rule) {
            this.checkInUsed(sqlStatement);
        }
    }

    private void checkExist(DropShardingKeyGeneratorStatement sqlStatement) {
        Collection notExistKeyGenerators = sqlStatement.getNames().stream().filter(each -> !this.rule.getConfiguration().getKeyGenerators().containsKey(each)).collect(Collectors.toList());
        ShardingSpherePreconditions.checkState((boolean)notExistKeyGenerators.isEmpty(), () -> new UnregisteredAlgorithmException("Key generator", notExistKeyGenerators, new SQLExceptionIdentifier(this.database.getName())));
    }

    private void checkInUsed(DropShardingKeyGeneratorStatement sqlStatement) {
        Collection<String> usedKeyGenerators = this.getUsedKeyGenerators();
        Collection inUsedNames = sqlStatement.getNames().stream().filter(usedKeyGenerators::contains).collect(Collectors.toList());
        ShardingSpherePreconditions.checkState((boolean)inUsedNames.isEmpty(), () -> new InUsedAlgorithmException("Key generator", this.database.getName(), inUsedNames));
    }

    private Collection<String> getUsedKeyGenerators() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        this.rule.getConfiguration().getTables().stream().filter(each -> null != each.getKeyGenerateStrategy()).forEach(each -> result.add(each.getKeyGenerateStrategy().getKeyGeneratorName()));
        this.rule.getConfiguration().getAutoTables().stream().filter(each -> null != each.getKeyGenerateStrategy()).forEach(each -> result.add(each.getKeyGenerateStrategy().getKeyGeneratorName()));
        KeyGenerateStrategyConfiguration keyGenerateStrategy = this.rule.getConfiguration().getDefaultKeyGenerateStrategy();
        if (null != keyGenerateStrategy && !Strings.isNullOrEmpty((String)keyGenerateStrategy.getKeyGeneratorName())) {
            result.add(keyGenerateStrategy.getKeyGeneratorName());
        }
        return result;
    }

    public ShardingRuleConfiguration buildToBeDroppedRuleConfiguration(DropShardingKeyGeneratorStatement sqlStatement) {
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        for (String each : sqlStatement.getNames()) {
            result.getKeyGenerators().put(each, (AlgorithmConfiguration)this.rule.getConfiguration().getKeyGenerators().get(each));
        }
        return result;
    }

    public boolean hasAnyOneToBeDropped(DropShardingKeyGeneratorStatement sqlStatement) {
        return !Collections.disjoint(this.rule.getConfiguration().getKeyGenerators().keySet(), sqlStatement.getNames());
    }

    public Class<ShardingRule> getRuleClass() {
        return ShardingRule.class;
    }

    public Class<DropShardingKeyGeneratorStatement> getType() {
        return DropShardingKeyGeneratorStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }

    @Generated
    public void setRule(ShardingRule rule) {
        this.rule = rule;
    }
}

