/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.parameter;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.model.physical.model.schema.PhysicalSchemaMetaData;
import org.apache.shardingsphere.infra.rewrite.parameter.rewriter.ParameterRewriter;
import org.apache.shardingsphere.infra.rewrite.parameter.rewriter.ParameterRewriterBuilder;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.RouteContextAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.SchemaMetaDataAware;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.rewrite.parameter.impl.ShardingGeneratedKeyInsertValueParameterRewriter;
import org.apache.shardingsphere.sharding.rewrite.parameter.impl.ShardingPaginationParameterRewriter;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.aware.ShardingRuleAware;

public final class ShardingParameterRewriterBuilder
implements ParameterRewriterBuilder {
    private final ShardingRule shardingRule;
    private final RouteContext routeContext;

    public Collection<ParameterRewriter> getParameterRewriters(PhysicalSchemaMetaData schemaMetaData) {
        Collection<ParameterRewriter> result = ShardingParameterRewriterBuilder.getParameterRewriters();
        for (ParameterRewriter each : result) {
            this.setUpParameterRewriters(each, schemaMetaData);
        }
        return result;
    }

    private static Collection<ParameterRewriter> getParameterRewriters() {
        LinkedList<ParameterRewriter> result = new LinkedList<ParameterRewriter>();
        result.add(new ShardingGeneratedKeyInsertValueParameterRewriter());
        result.add(new ShardingPaginationParameterRewriter());
        return result;
    }

    private void setUpParameterRewriters(ParameterRewriter parameterRewriter, PhysicalSchemaMetaData schemaMetaData) {
        if (parameterRewriter instanceof SchemaMetaDataAware) {
            ((SchemaMetaDataAware)parameterRewriter).setSchemaMetaData(schemaMetaData);
        }
        if (parameterRewriter instanceof ShardingRuleAware) {
            ((ShardingRuleAware)parameterRewriter).setShardingRule(this.shardingRule);
        }
        if (parameterRewriter instanceof RouteContextAware) {
            ((RouteContextAware)parameterRewriter).setRouteContext(this.routeContext);
        }
    }

    @Generated
    public ShardingParameterRewriterBuilder(ShardingRule shardingRule, RouteContext routeContext) {
        this.shardingRule = shardingRule;
        this.routeContext = routeContext;
    }
}

