/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.generator.impl;

import org.apache.shardingsphere.infra.binder.segment.select.orderby.OrderByItem;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.OptionalSQLTokenGenerator;
import org.apache.shardingsphere.sharding.rewrite.token.generator.IgnoreForSingleRoute;
import org.apache.shardingsphere.sharding.rewrite.token.pojo.OrderByToken;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.ExpressionOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class OrderByTokenGenerator
implements OptionalSQLTokenGenerator<SelectStatementContext>,
IgnoreForSingleRoute {
    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof SelectStatementContext && ((SelectStatementContext)sqlStatementContext).getOrderByContext().isGenerated();
    }

    public OrderByToken generateSQLToken(SelectStatementContext selectStatementContext) {
        OrderByToken result = new OrderByToken(this.generateOrderByIndex(selectStatementContext));
        for (OrderByItem each : selectStatementContext.getOrderByContext().getItems()) {
            String columnLabel;
            if (each.getSegment() instanceof ColumnOrderByItemSegment) {
                ColumnOrderByItemSegment columnOrderByItemSegment = (ColumnOrderByItemSegment)each.getSegment();
                columnLabel = columnOrderByItemSegment.getText();
            } else {
                columnLabel = each.getSegment() instanceof ExpressionOrderByItemSegment ? ((ExpressionOrderByItemSegment)each.getSegment()).getText() : String.valueOf(each.getIndex());
            }
            result.getColumnLabels().add(columnLabel);
            result.getOrderDirections().add(each.getSegment().getOrderDirection());
        }
        return result;
    }

    private int generateOrderByIndex(SelectStatementContext selectStatementContext) {
        if (selectStatementContext.getGroupByContext().getLastIndex() > 0) {
            return selectStatementContext.getGroupByContext().getLastIndex() + 1;
        }
        SelectStatement selectStatement = (SelectStatement)selectStatementContext.getSqlStatement();
        if (selectStatement.getWhere().isPresent()) {
            return ((WhereSegment)selectStatement.getWhere().get()).getStopIndex() + 1;
        }
        return selectStatementContext.getSimpleTableSegments().stream().mapToInt(SimpleTableSegment::getStopIndex).max().getAsInt() + 1;
    }
}

