/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.token.pojo;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.RouteUnitAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.Substitutable;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class TableToken
extends SQLToken
implements Substitutable,
RouteUnitAware {
    private final int stopIndex;
    private final IdentifierValue tableName;
    private final IdentifierValue owner;
    private final SQLStatementContext sqlStatementContext;
    private final ShardingRule shardingRule;

    public TableToken(int startIndex, int stopIndex, SimpleTableSegment tableSegment, SQLStatementContext sqlStatementContext, ShardingRule shardingRule) {
        super(startIndex);
        this.stopIndex = stopIndex;
        this.tableName = tableSegment.getTableName().getIdentifier();
        this.sqlStatementContext = sqlStatementContext;
        this.owner = tableSegment.getOwner().isPresent() ? ((OwnerSegment)tableSegment.getOwner().get()).getIdentifier() : null;
        this.shardingRule = shardingRule;
    }

    public String toString(RouteUnit routeUnit) {
        String actualTableName = this.getLogicAndActualTables(routeUnit).get(this.tableName.getValue().toLowerCase());
        actualTableName = null == actualTableName ? this.tableName.getValue().toLowerCase() : actualTableName;
        String owner = "";
        if (null != this.owner && routeUnit.getDataSourceMapper().getLogicName().equals(this.owner.getValue())) {
            owner = this.owner.getQuoteCharacter().wrap(routeUnit.getDataSourceMapper().getActualName()) + ".";
        }
        return Joiner.on((String)"").join((Object)owner, (Object)this.tableName.getQuoteCharacter().wrap(actualTableName), new Object[0]);
    }

    private Map<String, String> getLogicAndActualTables(RouteUnit routeUnit) {
        Collection tableNames = this.sqlStatementContext.getTablesContext().getTableNames();
        HashMap<String, String> result = new HashMap<String, String>(tableNames.size(), 1.0f);
        for (RouteMapper each : routeUnit.getTableMappers()) {
            result.put(each.getLogicName().toLowerCase(), each.getActualName());
            result.putAll(this.shardingRule.getLogicAndActualTablesFromBindingTable(routeUnit.getDataSourceMapper().getLogicName(), each.getLogicName(), each.getActualName(), tableNames));
        }
        return result;
    }

    @Generated
    public int getStopIndex() {
        return this.stopIndex;
    }
}

