/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.type.complex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingConditions;
import org.apache.shardingsphere.sharding.route.engine.type.ShardingRouteEngine;
import org.apache.shardingsphere.sharding.route.engine.type.complex.ShardingCartesianRoutingEngine;
import org.apache.shardingsphere.sharding.route.engine.type.standard.ShardingStandardRoutingEngine;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.TableRule;

public final class ShardingComplexRoutingEngine
implements ShardingRouteEngine {
    private final Collection<String> logicTables;
    private final ShardingConditions shardingConditions;
    private final ConfigurationProperties props;

    @Override
    public void route(RouteContext routeContext, ShardingRule shardingRule) {
        RouteContext newRouteContext;
        TreeSet bindingTableNames = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        ArrayList<RouteContext> routeContexts = new ArrayList<RouteContext>(this.logicTables.size());
        for (String each : this.logicTables) {
            RouteContext newRouteContext2 = new RouteContext();
            Optional tableRule = shardingRule.findTableRule(each);
            if (!tableRule.isPresent()) continue;
            if (!bindingTableNames.contains(each)) {
                new ShardingStandardRoutingEngine(((TableRule)tableRule.get()).getLogicTable(), this.shardingConditions, this.props).route(newRouteContext2, shardingRule);
                routeContexts.add(newRouteContext2);
            }
            shardingRule.findBindingTableRule(each).ifPresent(bindingTableRule -> bindingTableNames.addAll(bindingTableRule.getTableRules().stream().map(TableRule::getLogicTable).collect(Collectors.toList())));
        }
        if (routeContexts.isEmpty()) {
            throw new ShardingSphereException("Cannot find table rule and default data source with logic tables: '%s'", new Object[]{this.logicTables});
        }
        if (1 == routeContexts.size()) {
            newRouteContext = (RouteContext)routeContexts.iterator().next();
            routeContext.getOriginalDataNodes().addAll(newRouteContext.getOriginalDataNodes());
            routeContext.getRouteUnits().addAll(newRouteContext.getRouteUnits());
            return;
        }
        newRouteContext = new RouteContext();
        new ShardingCartesianRoutingEngine(routeContexts).route(newRouteContext, shardingRule);
        routeContext.getOriginalDataNodes().addAll(newRouteContext.getOriginalDataNodes());
        routeContext.getRouteUnits().addAll(newRouteContext.getRouteUnits());
    }

    @Generated
    public ShardingComplexRoutingEngine(Collection<String> logicTables, ShardingConditions shardingConditions, ConfigurationProperties props) {
        this.logicTables = logicTables;
        this.shardingConditions = shardingConditions;
        this.props = props;
    }
}

