/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.validator.ddl.impl;

import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.metadata.model.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.route.engine.validator.ddl.ShardingDDLStatementValidator;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.AlterViewStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.ddl.AlterViewStatementHandler;

public final class ShardingAlterViewStatementValidator
extends ShardingDDLStatementValidator<AlterViewStatement> {
    @Override
    public void preValidate(ShardingRule shardingRule, SQLStatementContext<AlterViewStatement> sqlStatementContext, List<Object> parameters, ShardingSphereMetaData metaData) {
        Optional selectStatement = AlterViewStatementHandler.getSelectStatement((AlterViewStatement)((AlterViewStatement)sqlStatementContext.getSqlStatement()));
        selectStatement.ifPresent(select -> {
            TableExtractor extractor = new TableExtractor();
            extractor.extractTablesFromSelect(select);
            this.validateShardingTable(metaData, extractor.getRewriteTables());
        });
    }

    @Override
    public void postValidate(AlterViewStatement sqlStatement, RouteContext routeContext) {
    }
}

