/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.validator.dml;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.sharding.route.engine.validator.ShardingStatementValidator;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public abstract class ShardingDMLStatementValidator<T extends SQLStatement>
implements ShardingStatementValidator<T> {
    protected void validateShardingMultipleTable(ShardingRule shardingRule, SQLStatementContext<T> sqlStatementContext) {
        Collection tableNames = sqlStatementContext.getTablesContext().getTableNames();
        Collection shardingTableNames = shardingRule.getShardingLogicTableNames(tableNames);
        if ((1 == shardingTableNames.size() || shardingRule.isAllBindingTables(shardingTableNames)) && !this.isAllValidTables(shardingRule, tableNames)) {
            throw new ShardingSphereException("Cannot support Multiple-Table for '%s'.", new Object[]{tableNames});
        }
    }

    private boolean isAllValidTables(ShardingRule shardingRule, Collection<String> tableNames) {
        LinkedList<String> allTableNames = new LinkedList<String>(tableNames);
        allTableNames.removeAll(shardingRule.getShardingLogicTableNames(tableNames));
        allTableNames.removeAll(shardingRule.getBroadcastTables());
        return allTableNames.isEmpty();
    }
}

