/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.validator.dml.impl;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.metadata.model.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.route.engine.validator.dml.ShardingDMLStatementValidator;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.AssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.OnDuplicateKeyColumnsSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.InsertStatementHandler;

public final class ShardingInsertStatementValidator
extends ShardingDMLStatementValidator<InsertStatement> {
    @Override
    public void preValidate(ShardingRule shardingRule, SQLStatementContext<InsertStatement> sqlStatementContext, List<Object> parameters, ShardingSphereMetaData metaData) {
        if (null == ((InsertStatementContext)sqlStatementContext).getInsertSelectContext()) {
            this.validateShardingMultipleTable(shardingRule, sqlStatementContext);
        }
        InsertStatement sqlStatement = (InsertStatement)sqlStatementContext.getSqlStatement();
        Optional onDuplicateKeyColumnsSegment = InsertStatementHandler.getOnDuplicateKeyColumnsSegment((InsertStatement)sqlStatement);
        String tableName = sqlStatement.getTable().getTableName().getIdentifier().getValue();
        if (onDuplicateKeyColumnsSegment.isPresent() && this.isUpdateShardingKey(shardingRule, (OnDuplicateKeyColumnsSegment)onDuplicateKeyColumnsSegment.get(), tableName)) {
            throw new ShardingSphereException("INSERT INTO ... ON DUPLICATE KEY UPDATE can not support update for sharding column.", new Object[0]);
        }
        Optional insertSelectSegment = sqlStatement.getInsertSelect();
        if (insertSelectSegment.isPresent() && this.isContainsKeyGenerateStrategy(shardingRule, tableName) && !this.isContainsKeyGenerateColumn(shardingRule, sqlStatement.getColumns(), tableName)) {
            throw new ShardingSphereException("INSERT INTO ... SELECT can not support applying keyGenerator to absent generateKeyColumn.", new Object[0]);
        }
        TablesContext tablesContext = sqlStatementContext.getTablesContext();
        if (insertSelectSegment.isPresent() && !this.isAllSameTables(tablesContext.getTableNames()) && !shardingRule.isAllBindingTables(tablesContext.getTableNames())) {
            throw new ShardingSphereException("The table inserted and the table selected must be the same or bind tables.", new Object[0]);
        }
    }

    private boolean isUpdateShardingKey(ShardingRule shardingRule, OnDuplicateKeyColumnsSegment onDuplicateKeyColumnsSegment, String tableName) {
        for (AssignmentSegment each : onDuplicateKeyColumnsSegment.getColumns()) {
            if (!shardingRule.isShardingColumn(each.getColumn().getIdentifier().getValue(), tableName)) continue;
            return true;
        }
        return false;
    }

    private boolean isContainsKeyGenerateStrategy(ShardingRule shardingRule, String tableName) {
        return shardingRule.findGenerateKeyColumnName(tableName).isPresent();
    }

    private boolean isContainsKeyGenerateColumn(ShardingRule shardingRule, Collection<ColumnSegment> columns, String tableName) {
        return columns.isEmpty() || columns.stream().anyMatch(each -> shardingRule.isGenerateKeyColumn(each.getIdentifier().getValue(), tableName));
    }

    private boolean isAllSameTables(Collection<String> tableNames) {
        return 1L == tableNames.stream().distinct().count();
    }

    @Override
    public void postValidate(InsertStatement sqlStatement, RouteContext routeContext) {
    }
}

