/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.distsql.segment;

import com.google.common.base.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.api.ASTNode;

public final class SingleTableSegment
implements ASTNode {
    private final String storageUnitName;
    private final String schemaName;
    private final String tableName;

    public Optional<String> getSchemaName() {
        return Optional.ofNullable(this.schemaName);
    }

    public String toString() {
        return null == this.schemaName ? this.storageUnitName + "." + this.tableName : this.storageUnitName + "." + this.schemaName + "." + this.tableName;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (null == object || this.getClass() != object.getClass()) {
            return false;
        }
        SingleTableSegment segment = (SingleTableSegment)object;
        return Objects.equal((Object)this.storageUnitName.toUpperCase(), (Object)segment.storageUnitName.toUpperCase()) && Objects.equal((Object)this.tableName.toUpperCase(), (Object)segment.tableName.toUpperCase()) && Objects.equal((Object)(null == this.schemaName ? null : this.schemaName.toUpperCase()), null == segment.schemaName ? null : segment.schemaName.toUpperCase());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.storageUnitName.toUpperCase(), this.tableName.toUpperCase(), null == this.schemaName ? null : this.schemaName.toUpperCase()});
    }

    @Generated
    public SingleTableSegment(String storageUnitName, String schemaName, String tableName) {
        this.storageUnitName = storageUnitName;
        this.schemaName = schemaName;
        this.tableName = tableName;
    }

    @Generated
    public String getStorageUnitName() {
        return this.storageUnitName;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }
}

