/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.advanced.resultset;

import java.sql.ResultSetMetaData;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.shardingsphere.infra.binder.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.sqlfederation.advanced.resultset.WrapperAdapter;

public final class SQLFederationResultSetMetaData
extends WrapperAdapter
implements ResultSetMetaData {
    private final ShardingSphereSchema schema;
    private final AbstractSchema filterableSchema;
    private final RelDataTypeFactory relDataTypeFactory;
    private final SelectStatementContext selectStatementContext;
    private final RelDataType validatedNodeType;
    private final Map<Integer, String> indexAndColumnLabels;

    public SQLFederationResultSetMetaData(ShardingSphereSchema schema, AbstractSchema filterableSchema, SelectStatementContext selectStatementContext, RelDataType validatedNodeType, Map<Integer, String> indexAndColumnLabels) {
        this.schema = schema;
        this.filterableSchema = filterableSchema;
        this.relDataTypeFactory = new JavaTypeFactoryImpl();
        this.selectStatementContext = selectStatementContext;
        this.validatedNodeType = validatedNodeType;
        this.indexAndColumnLabels = indexAndColumnLabels;
    }

    @Override
    public int getColumnCount() {
        return this.validatedNodeType.getFieldCount();
    }

    @Override
    public boolean isAutoIncrement(int column) {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) {
        return true;
    }

    @Override
    public boolean isSearchable(int column) {
        return false;
    }

    @Override
    public boolean isCurrency(int column) {
        return false;
    }

    @Override
    public int isNullable(int column) {
        Optional table = this.findTableName(column).flatMap(optional -> Optional.ofNullable(this.filterableSchema.getTable(optional)));
        return !table.isPresent() || ((Table)table.get()).getRowType(this.relDataTypeFactory).isNullable() ? 1 : 0;
    }

    @Override
    public boolean isSigned(int column) {
        return true;
    }

    @Override
    public int getColumnDisplaySize(int column) {
        return this.findTableName(column).flatMap(optional -> Optional.ofNullable(this.filterableSchema.getTable(optional))).map(optional -> optional.getRowType(this.relDataTypeFactory).getPrecision()).orElse(0);
    }

    @Override
    public String getColumnLabel(int column) {
        return this.indexAndColumnLabels.get(column);
    }

    @Override
    public String getColumnName(int column) {
        Projection projection = (Projection)this.selectStatementContext.getProjectionsContext().getExpandProjections().get(column - 1);
        if (projection instanceof ColumnProjection) {
            return ((ColumnProjection)projection).getName();
        }
        return this.getColumnLabel(column);
    }

    @Override
    public String getSchemaName(int column) {
        return "logic_db";
    }

    @Override
    public int getPrecision(int column) {
        Optional table = this.findTableName(column).flatMap(optional -> Optional.ofNullable(this.filterableSchema.getTable(optional)));
        return !table.isPresent() || -1 == ((Table)table.get()).getRowType(this.relDataTypeFactory).getPrecision() ? 0 : ((Table)table.get()).getRowType(this.relDataTypeFactory).getPrecision();
    }

    @Override
    public int getScale(int column) {
        Optional table = this.findTableName(column).flatMap(optional -> Optional.ofNullable(this.filterableSchema.getTable(optional)));
        return !table.isPresent() || Integer.MIN_VALUE == ((Table)table.get()).getRowType(this.relDataTypeFactory).getScale() ? 0 : ((Table)table.get()).getRowType(this.relDataTypeFactory).getScale();
    }

    @Override
    public String getTableName(int column) {
        return this.findTableName(column).orElse("");
    }

    @Override
    public String getCatalogName(int column) {
        return "logic_db";
    }

    @Override
    public int getColumnType(int column) {
        return ((RelDataTypeField)this.validatedNodeType.getFieldList().get(column - 1)).getType().getSqlTypeName().getJdbcOrdinal();
    }

    @Override
    public String getColumnTypeName(int column) {
        return ((RelDataTypeField)this.validatedNodeType.getFieldList().get(column - 1)).getType().getSqlTypeName().getName();
    }

    @Override
    public boolean isReadOnly(int column) {
        return false;
    }

    @Override
    public boolean isWritable(int column) {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) {
        return false;
    }

    @Override
    public String getColumnClassName(int column) {
        return ((RelDataTypeField)this.validatedNodeType.getFieldList().get(column - 1)).getType().getSqlTypeName().getClass().getName();
    }

    private Optional<String> findTableName(int column) {
        Projection projection = (Projection)this.selectStatementContext.getProjectionsContext().getExpandProjections().get(column - 1);
        if (projection instanceof ColumnProjection) {
            Map tableNamesByColumnProjection = this.selectStatementContext.getTablesContext().findTableNamesByColumnProjection(Collections.singletonList((ColumnProjection)projection), this.schema);
            return Optional.of((String)tableNamesByColumnProjection.get(projection.getExpression()));
        }
        return Optional.empty();
    }
}

