/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.advanced;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.EnumerableInterpretable;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.runtime.Bindable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.data.ShardingSphereData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.ShardingSphereRuleMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.sqlfederation.SQLFederationDataContext;
import org.apache.shardingsphere.sqlfederation.advanced.resultset.SQLFederationResultSet;
import org.apache.shardingsphere.sqlfederation.executor.FilterableTableScanExecutor;
import org.apache.shardingsphere.sqlfederation.executor.TableScanExecutorContext;
import org.apache.shardingsphere.sqlfederation.optimizer.SQLOptimizeContext;
import org.apache.shardingsphere.sqlfederation.optimizer.SQLOptimizeEngine;
import org.apache.shardingsphere.sqlfederation.optimizer.context.OptimizerContext;
import org.apache.shardingsphere.sqlfederation.optimizer.context.OptimizerContextFactory;
import org.apache.shardingsphere.sqlfederation.optimizer.context.parser.OptimizerParserContext;
import org.apache.shardingsphere.sqlfederation.optimizer.executor.TableScanExecutor;
import org.apache.shardingsphere.sqlfederation.optimizer.metadata.filter.FilterableSchema;
import org.apache.shardingsphere.sqlfederation.optimizer.util.SQLFederationPlannerUtil;
import org.apache.shardingsphere.sqlfederation.spi.SQLFederationExecutor;
import org.apache.shardingsphere.sqlfederation.spi.SQLFederationExecutorContext;

public final class AdvancedSQLFederationExecutor
implements SQLFederationExecutor {
    private static final JavaTypeFactory JAVA_TYPE_FACTORY = new JavaTypeFactoryImpl();
    private String databaseName;
    private String schemaName;
    private OptimizerContext optimizerContext;
    private ShardingSphereRuleMetaData globalRuleMetaData;
    private ConfigurationProperties props;
    private ShardingSphereData data;
    private JDBCExecutor jdbcExecutor;
    private ResultSet resultSet;

    public void init(String databaseName, String schemaName, ShardingSphereMetaData metaData, ShardingSphereData data, JDBCExecutor jdbcExecutor) {
        this.databaseName = databaseName;
        this.schemaName = schemaName;
        this.optimizerContext = OptimizerContextFactory.create((Map)metaData.getDatabases(), (ShardingSphereRuleMetaData)metaData.getGlobalRuleMetaData());
        this.globalRuleMetaData = metaData.getGlobalRuleMetaData();
        this.props = metaData.getProps();
        this.data = data;
        this.jdbcExecutor = jdbcExecutor;
    }

    public ResultSet executeQuery(DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, JDBCExecutorCallback<? extends ExecuteResult> callback, SQLFederationExecutorContext federationContext) {
        SQLStatementContext sqlStatementContext = federationContext.getQueryContext().getSqlStatementContext();
        Preconditions.checkArgument((boolean)(sqlStatementContext instanceof SelectStatementContext), (Object)"SQL statement context must be select statement context.");
        ShardingSphereDatabase database = federationContext.getMetaData().getDatabase(this.databaseName);
        ShardingSphereSchema schema = database.getSchema(this.schemaName);
        AbstractSchema sqlFederationSchema = this.createSQLFederationSchema(prepareEngine, database.getProtocolType(), schema, callback, federationContext);
        Map<String, Object> params = this.createParameters(federationContext.getQueryContext().getParameters());
        this.resultSet = this.execute((SelectStatementContext)sqlStatementContext, schema, sqlFederationSchema, params);
        return this.resultSet;
    }

    private Map<String, Object> createParameters(List<Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>(params.size(), 1.0f);
        int index = 0;
        for (Object each : params) {
            result.put("?" + index++, each);
        }
        return result;
    }

    private AbstractSchema createSQLFederationSchema(DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, DatabaseType protocolType, ShardingSphereSchema schema, JDBCExecutorCallback<? extends ExecuteResult> callback, SQLFederationExecutorContext federationContext) {
        TableScanExecutorContext executorContext = new TableScanExecutorContext(this.databaseName, this.schemaName, this.props, federationContext);
        FilterableTableScanExecutor executor = new FilterableTableScanExecutor(prepareEngine, this.jdbcExecutor, callback, this.optimizerContext, this.globalRuleMetaData, executorContext, this.data);
        return new FilterableSchema(this.schemaName, schema, protocolType, JAVA_TYPE_FACTORY, (TableScanExecutor)executor);
    }

    private ResultSet execute(SelectStatementContext selectStatementContext, ShardingSphereSchema schema, AbstractSchema sqlFederationSchema, Map<String, Object> params) {
        OptimizerParserContext parserContext = this.optimizerContext.getParserContext(this.databaseName);
        CalciteConnectionConfigImpl connectionConfig = new CalciteConnectionConfigImpl(parserContext.getDialectProps());
        CalciteCatalogReader catalogReader = SQLFederationPlannerUtil.createCatalogReader((String)this.schemaName, (Schema)sqlFederationSchema, (RelDataTypeFactory)JAVA_TYPE_FACTORY, (CalciteConnectionConfig)connectionConfig);
        SqlValidator validator = SQLFederationPlannerUtil.createSqlValidator((CalciteCatalogReader)catalogReader, (RelDataTypeFactory)JAVA_TYPE_FACTORY, (DatabaseType)parserContext.getDatabaseType(), (CalciteConnectionConfig)connectionConfig);
        SqlToRelConverter converter = SQLFederationPlannerUtil.createSqlToRelConverter((CalciteCatalogReader)catalogReader, (SqlValidator)validator, (RelOptCluster)SQLFederationPlannerUtil.createRelOptCluster((RelDataTypeFactory)JAVA_TYPE_FACTORY), (SQLParserRule)this.optimizerContext.getSqlParserRule(), (DatabaseType)parserContext.getDatabaseType(), (boolean)true);
        RelOptPlanner hepPlanner = this.optimizerContext.getPlannerContext(this.databaseName).getHepPlanner();
        SQLOptimizeContext optimizeContext = new SQLOptimizeEngine(converter, hepPlanner).optimize(selectStatementContext.getSqlStatement());
        Bindable executablePlan = EnumerableInterpretable.toBindable(Collections.emptyMap(), null, (EnumerableRel)((EnumerableRel)optimizeContext.getBestPlan()), (EnumerableRel.Prefer)EnumerableRel.Prefer.ARRAY);
        Enumerator enumerator = executablePlan.bind((DataContext)new SQLFederationDataContext(validator, converter, params)).enumerator();
        return new SQLFederationResultSet((Enumerator<Object>)enumerator, schema, sqlFederationSchema, selectStatementContext, optimizeContext.getValidatedNodeType());
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public void close() throws SQLException {
        if (null != this.resultSet) {
            this.resultSet.close();
        }
    }

    public boolean isDefault() {
        return true;
    }

    public String getType() {
        return "ADVANCED";
    }
}

