/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.optimizer.metadata.translatable;

import java.util.Collections;
import java.util.regex.Pattern;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.shardingsphere.sqlfederation.optimizer.metadata.translatable.TranslatableTableScan;

public class TranslatableFilterRule
extends RelOptRule {
    public static final TranslatableFilterRule INSTANCE = new TranslatableFilterRule(RelFactories.LOGICAL_BUILDER);
    private static final Pattern CONDITION_PATTERN = Pattern.compile("\\$[A-Za-z]");

    public TranslatableFilterRule(RelBuilderFactory relBuilderFactory) {
        super(TranslatableFilterRule.operand(LogicalFilter.class, (RelOptRuleOperand)TranslatableFilterRule.operand(TranslatableTableScan.class, (RelOptRuleOperandChildren)TranslatableFilterRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), relBuilderFactory, "TranslatableFilterRule");
    }

    public boolean matches(RelOptRuleCall call) {
        LogicalFilter filter = (LogicalFilter)call.rel(0);
        RexCall condition = (RexCall)filter.getCondition();
        for (RexNode each : condition.getOperands()) {
            if (!CONDITION_PATTERN.matcher(each.toString()).find()) continue;
            return false;
        }
        return true;
    }

    public void onMatch(RelOptRuleCall call) {
        LogicalFilter filter = (LogicalFilter)call.rel(0);
        TranslatableTableScan scan = (TranslatableTableScan)call.rel(1);
        call.transformTo((RelNode)new TranslatableTableScan(scan.getCluster(), scan.getTable(), scan.getTranslatableTable(), Collections.singletonList(filter.getCondition()), scan.getFields()));
    }
}

