/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.optimizer.converter.segment.window;

import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.WindowItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.WindowSegment;
import org.apache.shardingsphere.sqlfederation.optimizer.converter.segment.expression.ExpressionConverter;

public final class WindowConverter {
    public static Optional<SqlNodeList> convert(WindowSegment segment) {
        LinkedList<SqlWindow> sqlWindows = new LinkedList<SqlWindow>();
        for (WindowItemSegment each : segment.getItemSegments()) {
            SqlIdentifier sqlIdentifier = null == each.getWindowName() ? new SqlIdentifier("", SqlParserPos.ZERO) : new SqlIdentifier(each.getWindowName().getValue(), SqlParserPos.ZERO);
            LinkedList partitionNodes = new LinkedList();
            each.getPartitionListSegments().forEach(expressionSegment -> ExpressionConverter.convert(expressionSegment).ifPresent(partitionNodes::add));
            SqlNodeList partitionList = new SqlNodeList(partitionNodes, SqlParserPos.ZERO);
            SqlNodeList orderList = new SqlNodeList(SqlParserPos.ZERO);
            SqlWindow sqlWindow = new SqlWindow(SqlParserPos.ZERO, sqlIdentifier, null, partitionList, orderList, SqlLiteral.createBoolean((boolean)false, (SqlParserPos)SqlParserPos.ZERO), null, null, null);
            sqlWindows.add(sqlWindow);
        }
        SqlNodeList result = new SqlNodeList(sqlWindows, SqlParserPos.ZERO);
        return Optional.of(result);
    }

    @Generated
    private WindowConverter() {
    }
}

