/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.optimizer.metadata.schema;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.util.Map;
import lombok.Generated;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.sqlfederation.optimizer.metadata.schema.SQLFederationSchema;

public final class SQLFederationDatabase
extends AbstractSchema {
    private final String name;
    private final Map<String, Schema> subSchemaMap;

    public SQLFederationDatabase(ShardingSphereDatabase database, DatabaseType protocolType, JavaTypeFactory javaTypeFactory) {
        this.name = database.getName();
        this.subSchemaMap = this.createSubSchemaMap(database, protocolType, javaTypeFactory);
    }

    private Map<String, Schema> createSubSchemaMap(ShardingSphereDatabase database, DatabaseType protocolType, JavaTypeFactory javaTypeFactory) {
        CaseInsensitiveMap result = new CaseInsensitiveMap(database.getSchemas().size(), 1.0f);
        for (Map.Entry entry : database.getSchemas().entrySet()) {
            result.put((String)entry.getKey(), new SQLFederationSchema((String)entry.getKey(), (ShardingSphereSchema)entry.getValue(), protocolType, javaTypeFactory));
        }
        return result;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<String, Schema> getSubSchemaMap() {
        return this.subSchemaMap;
    }
}

