/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.binder.segment.select.pagination.engine;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.sql.parser.binder.segment.select.pagination.PaginationContext;
import org.apache.shardingsphere.sql.parser.binder.segment.select.pagination.engine.LimitPaginationContextEngine;
import org.apache.shardingsphere.sql.parser.binder.segment.select.pagination.engine.RowNumberPaginationContextEngine;
import org.apache.shardingsphere.sql.parser.binder.segment.select.pagination.engine.TopPaginationContextEngine;
import org.apache.shardingsphere.sql.parser.binder.segment.select.projection.ProjectionsContext;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.pagination.limit.LimitSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.pagination.top.TopProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.SelectStatement;

public final class PaginationContextEngine {
    public PaginationContext createPaginationContext(SelectStatement selectStatement, ProjectionsContext projectionsContext, List<Object> parameters) {
        Optional limitSegment = selectStatement.getLimit();
        if (limitSegment.isPresent()) {
            return new LimitPaginationContextEngine().createPaginationContext((LimitSegment)limitSegment.get(), parameters);
        }
        Optional<TopProjectionSegment> topProjectionSegment = this.findTopProjection(selectStatement);
        Optional whereSegment = selectStatement.getWhere();
        if (topProjectionSegment.isPresent()) {
            return new TopPaginationContextEngine().createPaginationContext(topProjectionSegment.get(), whereSegment.isPresent() ? ((WhereSegment)whereSegment.get()).getAndPredicates() : Collections.emptyList(), parameters);
        }
        if (whereSegment.isPresent()) {
            return new RowNumberPaginationContextEngine().createPaginationContext(((WhereSegment)whereSegment.get()).getAndPredicates(), projectionsContext, parameters);
        }
        return new PaginationContext(null, null, parameters);
    }

    private Optional<TopProjectionSegment> findTopProjection(SelectStatement selectStatement) {
        for (ProjectionSegment each : selectStatement.getProjections().getProjections()) {
            if (!(each instanceof TopProjectionSegment)) continue;
            return Optional.of((TopProjectionSegment)each);
        }
        return Optional.empty();
    }
}

