/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shardingsphere.sql.parser.SQLParseEngine;

public final class SQLParseEngineFactory {
    private static final Map<String, SQLParseEngine> ENGINES = new ConcurrentHashMap<String, SQLParseEngine>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SQLParseEngine getSQLParseEngine(String databaseTypeName) {
        if (ENGINES.containsKey(databaseTypeName)) {
            return ENGINES.get(databaseTypeName);
        }
        Map<String, SQLParseEngine> map = ENGINES;
        synchronized (map) {
            if (ENGINES.containsKey(databaseTypeName)) {
                return ENGINES.get(databaseTypeName);
            }
            SQLParseEngine result = new SQLParseEngine(databaseTypeName);
            ENGINES.put(databaseTypeName, result);
            return result;
        }
    }

    private SQLParseEngineFactory() {
    }
}

