/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.extractor.impl.common.column;

import com.google.common.base.Optional;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.shardingsphere.sql.parser.core.extractor.api.OptionalSQLSegmentExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.sql.parser.core.extractor.util.RuleName;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.TableSegment;

public final class ColumnExtractor
implements OptionalSQLSegmentExtractor {
    public Optional<ColumnSegment> extract(ParserRuleContext ancestorNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        Optional<ParserRuleContext> columnNode = ExtractorUtils.findFirstChildNode(ancestorNode, RuleName.COLUMN_NAME);
        return columnNode.isPresent() ? Optional.of((Object)this.getColumnSegment((ParserRuleContext)columnNode.get())) : Optional.absent();
    }

    private ColumnSegment getColumnSegment(ParserRuleContext columnNode) {
        ParserRuleContext nameNode = ExtractorUtils.getFirstChildNode(columnNode, RuleName.NAME);
        ColumnSegment result = new ColumnSegment(columnNode.getStart().getStartIndex(), columnNode.getStop().getStopIndex(), nameNode.getText());
        Optional<ParserRuleContext> ownerNode = ExtractorUtils.findFirstChildNodeNoneRecursive(columnNode, RuleName.OWNER);
        if (ownerNode.isPresent()) {
            result.setOwner(new TableSegment(((ParserRuleContext)ownerNode.get()).getStart().getStartIndex(), ((ParserRuleContext)ownerNode.get()).getStop().getStopIndex(), ((ParserRuleContext)ownerNode.get()).getText()));
        }
        return result;
    }
}

