/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.parser;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.api.SQLParser;
import org.apache.shardingsphere.sql.parser.core.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.sql.parser.core.extractor.util.RuleName;
import org.apache.shardingsphere.sql.parser.core.parser.SQLAST;
import org.apache.shardingsphere.sql.parser.core.parser.SQLParserFactory;
import org.apache.shardingsphere.sql.parser.core.rule.registry.ParseRuleRegistry;
import org.apache.shardingsphere.sql.parser.core.rule.registry.statement.SQLStatementRule;
import org.apache.shardingsphere.sql.parser.exception.SQLParsingException;

public final class SQLParserEngine {
    private final ParseRuleRegistry parseRuleRegistry;
    private final String databaseTypeName;
    private final String sql;

    public SQLAST parse() {
        ParseTree parseTree;
        SQLParser sqlParser = SQLParserFactory.newInstance(this.databaseTypeName, this.sql);
        try {
            ((Parser)sqlParser).setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
            ((ParserATNSimulator)((Parser)sqlParser).getInterpreter()).setPredictionMode(PredictionMode.SLL);
            parseTree = sqlParser.execute().getChild(0);
        }
        catch (ParseCancellationException ex) {
            ((Parser)sqlParser).reset();
            ((Parser)sqlParser).setErrorHandler((ANTLRErrorStrategy)new DefaultErrorStrategy());
            ((ParserATNSimulator)((Parser)sqlParser).getInterpreter()).setPredictionMode(PredictionMode.LL);
            parseTree = sqlParser.execute().getChild(0);
        }
        if (parseTree instanceof ErrorNode) {
            throw new SQLParsingException(String.format("Unsupported SQL of `%s`", this.sql), new Object[0]);
        }
        SQLStatementRule rule = this.parseRuleRegistry.getSQLStatementRule(this.databaseTypeName, parseTree.getClass().getSimpleName());
        if (null == rule) {
            throw new SQLParsingException(String.format("Unsupported SQL of `%s`", this.sql), new Object[0]);
        }
        return new SQLAST((ParserRuleContext)parseTree, this.getParameterMarkerIndexes((ParserRuleContext)parseTree), rule);
    }

    private Map<ParserRuleContext, Integer> getParameterMarkerIndexes(ParserRuleContext rootNode) {
        Collection<ParserRuleContext> placeholderNodes = ExtractorUtils.getAllDescendantNodes(rootNode, RuleName.PARAMETER_MARKER);
        HashMap<ParserRuleContext, Integer> result = new HashMap<ParserRuleContext, Integer>(placeholderNodes.size(), 1.0f);
        int index = 0;
        for (ParserRuleContext each : placeholderNodes) {
            result.put(each, index++);
        }
        return result;
    }

    @ConstructorProperties(value={"parseRuleRegistry", "databaseTypeName", "sql"})
    public SQLParserEngine(ParseRuleRegistry parseRuleRegistry, String databaseTypeName, String sql) {
        this.parseRuleRegistry = parseRuleRegistry;
        this.databaseTypeName = databaseTypeName;
        this.sql = sql;
    }
}

