/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser;

import java.util.Optional;
import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.cache.SQLParseResultCache;
import org.apache.shardingsphere.sql.parser.core.parser.SQLParserExecutor;
import org.apache.shardingsphere.sql.parser.core.visitor.ParseTreeVisitorFactory;
import org.apache.shardingsphere.sql.parser.core.visitor.VisitorRule;
import org.apache.shardingsphere.sql.parser.hook.SPIParsingHook;
import org.apache.shardingsphere.sql.parser.sql.statement.SQLStatement;

public final class SQLParserEngine {
    private final String databaseTypeName;
    private final SQLParseResultCache cache = new SQLParseResultCache();

    public SQLStatement parse(String sql, boolean useCache) {
        SPIParsingHook parsingHook = new SPIParsingHook();
        parsingHook.start(sql);
        try {
            SQLStatement result = this.parse0(sql, useCache);
            parsingHook.finishSuccess(result);
            return result;
        }
        catch (Exception ex) {
            parsingHook.finishFailure(ex);
            throw ex;
        }
    }

    private SQLStatement parse0(String sql, boolean useCache) {
        Optional<SQLStatement> cachedSQLStatement;
        if (useCache && (cachedSQLStatement = this.cache.getSQLStatement(sql)).isPresent()) {
            return cachedSQLStatement.get();
        }
        ParseTree parseTree = new SQLParserExecutor(this.databaseTypeName, sql).execute().getRootNode();
        SQLStatement result = (SQLStatement)ParseTreeVisitorFactory.newInstance(this.databaseTypeName, VisitorRule.valueOf(parseTree.getClass())).visit(parseTree);
        if (useCache) {
            this.cache.put(sql, result);
        }
        return result;
    }

    @Generated
    public SQLParserEngine(String databaseTypeName) {
        this.databaseTypeName = databaseTypeName;
    }
}

