/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.extractor.dal;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.shardingsphere.sql.parser.core.extractor.api.OptionalSQLSegmentExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.sql.parser.core.extractor.util.RuleName;
import org.apache.shardingsphere.sql.parser.sql.segment.dal.ShowLikeSegment;

public final class MySQLShowLikeExtractor
implements OptionalSQLSegmentExtractor {
    public Optional<ShowLikeSegment> extract(ParserRuleContext ancestorNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        Optional showLikeNode = ExtractorUtils.findFirstChildNode((ParserRuleContext)ancestorNode, (RuleName)RuleName.SHOW_LIKE);
        if (!showLikeNode.isPresent()) {
            return Optional.absent();
        }
        Optional stringLiteralsNode = ExtractorUtils.findFirstChildNode((ParserRuleContext)((ParserRuleContext)showLikeNode.get()), (RuleName)RuleName.STRING_LITERALS);
        Preconditions.checkState((boolean)stringLiteralsNode.isPresent());
        String pattern = ((ParserRuleContext)stringLiteralsNode.get()).getText().substring(1, ((ParserRuleContext)stringLiteralsNode.get()).getText().length() - 1);
        return Optional.of((Object)new ShowLikeSegment(((ParserRuleContext)stringLiteralsNode.get()).getStart().getStartIndex() + 1, ((ParserRuleContext)stringLiteralsNode.get()).getStop().getStopIndex() - 1, pattern));
    }
}

