/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.mysql.visitor.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.DDLVisitor;
import org.apache.shardingsphere.sql.parser.autogen.MySQLStatementParser;
import org.apache.shardingsphere.sql.parser.mysql.visitor.MySQLVisitor;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.AlterDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.CreateDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.column.alter.AddColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.column.alter.DropColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.column.alter.ModifyColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.column.alter.RenameColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.column.position.ColumnAfterPositionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.column.position.ColumnFirstPositionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.column.position.ColumnPositionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.constraint.ConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.constraint.DropPrimaryKeySegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.DataTypeSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.ddl.AlterTableStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.ddl.CreateDatabaseStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.ddl.CreateIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.ddl.CreateTableStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.ddl.CreateViewStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.ddl.DropDatabaseStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.ddl.DropIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.ddl.DropTableStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.ddl.DropViewStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.ddl.RenameTableStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.ddl.TruncateStatement;
import org.apache.shardingsphere.sql.parser.sql.value.collection.CollectionValue;

public final class MySQLDDLVisitor
extends MySQLVisitor
implements DDLVisitor {
    @Override
    public ASTNode visitCreateView(MySQLStatementParser.CreateViewContext ctx) {
        return new CreateViewStatement();
    }

    @Override
    public ASTNode visitDropView(MySQLStatementParser.DropViewContext ctx) {
        return new DropViewStatement();
    }

    @Override
    public ASTNode visitCreateDatabase(MySQLStatementParser.CreateDatabaseContext ctx) {
        return new CreateDatabaseStatement();
    }

    @Override
    public ASTNode visitDropDatabase(MySQLStatementParser.DropDatabaseContext ctx) {
        return new DropDatabaseStatement();
    }

    @Override
    public ASTNode visitRenameTableSpecification(MySQLStatementParser.RenameTableSpecificationContext ctx) {
        return new RenameTableStatement();
    }

    @Override
    public ASTNode visitCreateTable(MySQLStatementParser.CreateTableContext ctx) {
        CreateTableStatement result = new CreateTableStatement((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        if (null != ctx.createDefinitionClause()) {
            CollectionValue createDefinitions = (CollectionValue)this.visit((ParseTree)ctx.createDefinitionClause());
            for (CreateDefinitionSegment each : createDefinitions.getValue()) {
                if (each instanceof ColumnDefinitionSegment) {
                    result.getColumnDefinitions().add((ColumnDefinitionSegment)each);
                    continue;
                }
                if (!(each instanceof ConstraintDefinitionSegment)) continue;
                result.getConstraintDefinitions().add((ConstraintDefinitionSegment)each);
            }
        }
        return result;
    }

    @Override
    public ASTNode visitCreateDefinitionClause(MySQLStatementParser.CreateDefinitionClauseContext ctx) {
        CollectionValue result = new CollectionValue();
        for (MySQLStatementParser.CreateDefinitionContext each : ctx.createDefinition()) {
            if (null != each.columnDefinition()) {
                result.getValue().add((ColumnDefinitionSegment)this.visit((ParseTree)each.columnDefinition()));
            }
            if (null != each.constraintDefinition()) {
                result.getValue().add((ConstraintDefinitionSegment)this.visit((ParseTree)each.constraintDefinition()));
            }
            if (null == each.checkConstraintDefinition()) continue;
            result.getValue().add((ConstraintDefinitionSegment)this.visit((ParseTree)each.checkConstraintDefinition()));
        }
        return result;
    }

    @Override
    public ASTNode visitCreateLikeClause(MySQLStatementParser.CreateLikeClauseContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.tableName());
    }

    @Override
    public ASTNode visitAlterTable(MySQLStatementParser.AlterTableContext ctx) {
        AlterTableStatement result = new AlterTableStatement((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        if (null != ctx.alterDefinitionClause()) {
            for (AlterDefinitionSegment each : ((CollectionValue)this.visit((ParseTree)ctx.alterDefinitionClause())).getValue()) {
                if (each instanceof AddColumnDefinitionSegment) {
                    result.getAddColumnDefinitions().add((AddColumnDefinitionSegment)each);
                    continue;
                }
                if (each instanceof ModifyColumnDefinitionSegment) {
                    result.getModifyColumnDefinitions().add((ModifyColumnDefinitionSegment)each);
                    continue;
                }
                if (each instanceof DropColumnDefinitionSegment) {
                    result.getDropColumnDefinitions().add((DropColumnDefinitionSegment)each);
                    continue;
                }
                if (!(each instanceof ConstraintDefinitionSegment)) continue;
                result.getAddConstraintDefinitions().add((ConstraintDefinitionSegment)each);
            }
        }
        return result;
    }

    @Override
    public ASTNode visitAlterDefinitionClause(MySQLStatementParser.AlterDefinitionClauseContext ctx) {
        CollectionValue result = new CollectionValue();
        for (MySQLStatementParser.AlterSpecificationContext each : ctx.alterSpecification()) {
            ModifyColumnDefinitionSegment modifyColumnDefinition;
            if (null != each.addColumnSpecification()) {
                result.getValue().add((AddColumnDefinitionSegment)this.visit((ParseTree)each.addColumnSpecification()));
            }
            if (null != each.addConstraintSpecification()) {
                result.getValue().add((ConstraintDefinitionSegment)this.visit((ParseTree)each.addConstraintSpecification().constraintDefinition()));
            }
            if (null != each.changeColumnSpecification()) {
                modifyColumnDefinition = new ModifyColumnDefinitionSegment(each.changeColumnSpecification().getStart().getStartIndex(), each.changeColumnSpecification().getStop().getStopIndex(), (ColumnDefinitionSegment)this.visit((ParseTree)each.changeColumnSpecification().columnDefinition()));
                if (null != each.changeColumnSpecification().firstOrAfterColumn()) {
                    modifyColumnDefinition.setColumnPosition((ColumnPositionSegment)this.visit((ParseTree)each.changeColumnSpecification().firstOrAfterColumn()));
                }
                result.getValue().add(modifyColumnDefinition);
            }
            if (null != each.modifyColumnSpecification()) {
                modifyColumnDefinition = new ModifyColumnDefinitionSegment(each.modifyColumnSpecification().getStart().getStartIndex(), each.modifyColumnSpecification().getStop().getStopIndex(), (ColumnDefinitionSegment)this.visit((ParseTree)each.modifyColumnSpecification().columnDefinition()));
                if (null != each.modifyColumnSpecification().firstOrAfterColumn()) {
                    modifyColumnDefinition.setColumnPosition((ColumnPositionSegment)this.visit((ParseTree)each.modifyColumnSpecification().firstOrAfterColumn()));
                }
                result.getValue().add(modifyColumnDefinition);
            }
            if (null == each.dropColumnSpecification()) continue;
            result.getValue().add((DropColumnDefinitionSegment)this.visit((ParseTree)each.dropColumnSpecification()));
        }
        return result;
    }

    @Override
    public ASTNode visitAddColumnSpecification(MySQLStatementParser.AddColumnSpecificationContext ctx) {
        LinkedList<ColumnDefinitionSegment> columnDefinitions = new LinkedList<ColumnDefinitionSegment>();
        for (MySQLStatementParser.ColumnDefinitionContext each : ctx.columnDefinition()) {
            columnDefinitions.add((ColumnDefinitionSegment)this.visit((ParseTree)each));
        }
        AddColumnDefinitionSegment result = new AddColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnDefinitions);
        if (null != ctx.firstOrAfterColumn()) {
            Preconditions.checkState((1 == columnDefinitions.size() ? 1 : 0) != 0);
            result.setColumnPosition(this.getColumnPositionSegment((ColumnDefinitionSegment)columnDefinitions.iterator().next(), (ColumnPositionSegment)this.visit((ParseTree)ctx.firstOrAfterColumn())));
        }
        return result;
    }

    @Override
    public ASTNode visitColumnDefinition(MySQLStatementParser.ColumnDefinitionContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visit((ParseTree)ctx.columnName());
        DataTypeSegment dataTypeSegment = (DataTypeSegment)this.visit((ParseTree)ctx.dataType());
        boolean isPrimaryKey = this.isPrimaryKey(ctx);
        ColumnDefinitionSegment result = new ColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), column, dataTypeSegment, isPrimaryKey);
        result.getReferencedTables().addAll(this.getReferencedTables(ctx));
        return result;
    }

    private Collection<SimpleTableSegment> getReferencedTables(MySQLStatementParser.ColumnDefinitionContext ctx) {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        for (MySQLStatementParser.StorageOptionContext storageOptionContext : ctx.storageOption()) {
            if (null == storageOptionContext.dataTypeGenericOption() || null == storageOptionContext.dataTypeGenericOption().referenceDefinition()) continue;
            result.add((SimpleTableSegment)this.visit((ParseTree)storageOptionContext.dataTypeGenericOption().referenceDefinition()));
        }
        for (MySQLStatementParser.GeneratedOptionContext generatedOptionContext : ctx.generatedOption()) {
            if (null == generatedOptionContext.dataTypeGenericOption() || null == generatedOptionContext.dataTypeGenericOption().referenceDefinition()) continue;
            result.add((SimpleTableSegment)this.visit((ParseTree)generatedOptionContext.dataTypeGenericOption().referenceDefinition()));
        }
        return result;
    }

    private boolean isPrimaryKey(MySQLStatementParser.ColumnDefinitionContext ctx) {
        for (MySQLStatementParser.StorageOptionContext storageOptionContext : ctx.storageOption()) {
            if (null == storageOptionContext.dataTypeGenericOption() || null == storageOptionContext.dataTypeGenericOption().primaryKey()) continue;
            return true;
        }
        for (MySQLStatementParser.GeneratedOptionContext generatedOptionContext : ctx.generatedOption()) {
            if (null == generatedOptionContext.dataTypeGenericOption() || null == generatedOptionContext.dataTypeGenericOption().primaryKey()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ASTNode visitConstraintDefinition(MySQLStatementParser.ConstraintDefinitionContext ctx) {
        ConstraintDefinitionSegment result = new ConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        if (null != ctx.primaryKeyOption()) {
            result.getPrimaryKeyColumns().addAll(((CollectionValue)this.visit((ParseTree)ctx.primaryKeyOption().columnNames())).getValue());
        }
        if (null != ctx.foreignKeyOption()) {
            result.setReferencedTable((SimpleTableSegment)this.visit((ParseTree)ctx.foreignKeyOption().referenceDefinition()));
        }
        return result;
    }

    @Override
    public ASTNode visitCheckConstraintDefinition(MySQLStatementParser.CheckConstraintDefinitionContext ctx) {
        return new ConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
    }

    @Override
    public ASTNode visitChangeColumnSpecification(MySQLStatementParser.ChangeColumnSpecificationContext ctx) {
        return this.extractModifyColumnDefinition(ctx.getStart(), ctx.getStop(), ctx.columnDefinition(), ctx.firstOrAfterColumn());
    }

    @Override
    public ASTNode visitDropColumnSpecification(MySQLStatementParser.DropColumnSpecificationContext ctx) {
        return new DropColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), Collections.singletonList((ColumnSegment)this.visit((ParseTree)ctx.columnName())));
    }

    @Override
    public ASTNode visitDropPrimaryKeySpecification(MySQLStatementParser.DropPrimaryKeySpecificationContext ctx) {
        return new DropPrimaryKeySegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
    }

    @Override
    public ASTNode visitModifyColumnSpecification(MySQLStatementParser.ModifyColumnSpecificationContext ctx) {
        return this.extractModifyColumnDefinition(ctx.getStart(), ctx.getStop(), ctx.columnDefinition(), ctx.firstOrAfterColumn());
    }

    @Override
    public ASTNode visitRenameColumnSpecification(MySQLStatementParser.RenameColumnSpecificationContext ctx) {
        return new RenameColumnSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ColumnSegment)this.visit((ParseTree)ctx.columnName(0)), (ColumnSegment)this.visit((ParseTree)ctx.columnName(1)));
    }

    @Override
    public ASTNode visitReferenceDefinition(MySQLStatementParser.ReferenceDefinitionContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.tableName());
    }

    @Override
    public ASTNode visitForeignKeyOption(MySQLStatementParser.ForeignKeyOptionContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.referenceDefinition());
    }

    private ModifyColumnDefinitionSegment extractModifyColumnDefinition(Token start, Token stop, MySQLStatementParser.ColumnDefinitionContext columnDefinition, MySQLStatementParser.FirstOrAfterColumnContext firstOrAfterColumn) {
        ModifyColumnDefinitionSegment result = new ModifyColumnDefinitionSegment(start.getStartIndex(), stop.getStopIndex(), (ColumnDefinitionSegment)this.visit((ParseTree)columnDefinition));
        if (null != firstOrAfterColumn) {
            result.setColumnPosition(this.getColumnPositionSegment(result.getColumnDefinition(), (ColumnPositionSegment)this.visit((ParseTree)firstOrAfterColumn)));
        }
        return result;
    }

    @Override
    public ASTNode visitFirstOrAfterColumn(MySQLStatementParser.FirstOrAfterColumnContext ctx) {
        ColumnSegment columnName = null;
        if (null != ctx.columnName()) {
            columnName = (ColumnSegment)this.visit((ParseTree)ctx.columnName());
        }
        return null == ctx.columnName() ? new ColumnFirstPositionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnName) : new ColumnAfterPositionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnName);
    }

    private ColumnPositionSegment getColumnPositionSegment(ColumnDefinitionSegment columnDefinition, ColumnPositionSegment columnPosition) {
        return columnPosition instanceof ColumnFirstPositionSegment ? new ColumnFirstPositionSegment(columnPosition.getStartIndex(), columnPosition.getStopIndex(), columnPosition.getColumnName()) : new ColumnAfterPositionSegment(columnPosition.getStartIndex(), columnPosition.getStopIndex(), columnPosition.getColumnName());
    }

    @Override
    public ASTNode visitDropTable(MySQLStatementParser.DropTableContext ctx) {
        DropTableStatement result = new DropTableStatement();
        result.getTables().addAll(((CollectionValue)this.visit((ParseTree)ctx.tableNames())).getValue());
        return result;
    }

    @Override
    public ASTNode visitTruncateTable(MySQLStatementParser.TruncateTableContext ctx) {
        TruncateStatement result = new TruncateStatement();
        result.getTables().add((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        return result;
    }

    @Override
    public ASTNode visitCreateIndex(MySQLStatementParser.CreateIndexContext ctx) {
        CreateIndexStatement result = new CreateIndexStatement();
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        return result;
    }

    @Override
    public ASTNode visitDropIndex(MySQLStatementParser.DropIndexContext ctx) {
        DropIndexStatement result = new DropIndexStatement();
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        return result;
    }
}

