/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.mysql.visitor;

import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.shardingsphere.sql.parser.autogen.MySQLStatementBaseVisitor;
import org.apache.shardingsphere.sql.parser.autogen.MySQLStatementParser;
import org.apache.shardingsphere.sql.parser.sql.common.SQLStats;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.AliasSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class MySQLSQLStatVisitor
extends MySQLStatementBaseVisitor<SQLStats> {
    private final SQLStats sqlStats = new SQLStats();

    @Override
    public SQLStats visitTableFactor(MySQLStatementParser.TableFactorContext ctx) {
        if (null != ctx.tableName()) {
            SimpleTableSegment tableSegment = this.getTableName(ctx.tableName());
            if (null != ctx.alias()) {
                MySQLStatementParser.AliasContext aliasContext = ctx.alias();
                tableSegment.setAlias(new AliasSegment(aliasContext.start.getStartIndex(), aliasContext.stop.getStopIndex(), new IdentifierValue(aliasContext.textOrIdentifier().getText())));
            }
            this.sqlStats.addTable(tableSegment);
            return this.sqlStats;
        }
        super.visitTableFactor(ctx);
        return this.sqlStats;
    }

    @Override
    public SQLStats visitInsert(MySQLStatementParser.InsertContext ctx) {
        SimpleTableSegment tableSegment = this.getTableName(ctx.tableName());
        this.sqlStats.addTable(tableSegment);
        if (null != ctx.insertValuesClause()) {
            this.visit((ParseTree)ctx.insertValuesClause());
        } else if (null != ctx.insertSelectClause()) {
            this.visit((ParseTree)ctx.insertSelectClause());
        } else {
            this.visit((ParseTree)ctx.setAssignmentsClause());
        }
        return this.sqlStats;
    }

    @Override
    public SQLStats visitColumnRef(MySQLStatementParser.ColumnRefContext ctx) {
        this.sqlStats.addColumn(this.getColumn(ctx));
        return this.sqlStats;
    }

    @Override
    public SQLStats visitColumnDefinition(MySQLStatementParser.ColumnDefinitionContext ctx) {
        this.sqlStats.addColumn(new ColumnSegment(ctx.column_name.start.getStartIndex(), ctx.column_name.stop.getStopIndex(), new IdentifierValue(ctx.column_name.getText())));
        return this.sqlStats;
    }

    private ColumnSegment getColumn(MySQLStatementParser.ColumnRefContext ctx) {
        IdentifierValue name;
        OwnerSegment owner = null;
        if (2 == ctx.identifier().size()) {
            name = new IdentifierValue(ctx.identifier(1).getText());
            owner = new OwnerSegment(ctx.identifier((int)0).start.getStartIndex(), ctx.identifier((int)0).stop.getStopIndex(), new IdentifierValue(ctx.identifier(0).getText()));
        } else if (3 == ctx.identifier().size()) {
            name = new IdentifierValue(ctx.identifier(2).getText());
            owner = new OwnerSegment(ctx.identifier((int)1).start.getStartIndex(), ctx.identifier((int)1).stop.getStopIndex(), new IdentifierValue(ctx.identifier(1).getText()));
        } else {
            name = new IdentifierValue(ctx.identifier(0).getText());
        }
        ColumnSegment result = new ColumnSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), name);
        result.setOwner(owner);
        return result;
    }

    private SimpleTableSegment getTableName(MySQLStatementParser.TableNameContext ctx) {
        SimpleTableSegment result = new SimpleTableSegment(new TableNameSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), new IdentifierValue(ctx.name().identifier().getText())));
        MySQLStatementParser.OwnerContext owner = ctx.owner();
        if (null != owner) {
            result.setOwner(new OwnerSegment(owner.getStart().getStartIndex(), owner.getStop().getStopIndex(), new IdentifierValue(owner.identifier().getText())));
        }
        return result;
    }

    @Override
    public SQLStats visitTableName(MySQLStatementParser.TableNameContext ctx) {
        SimpleTableSegment tableSegment = this.getTableName(ctx);
        this.sqlStats.addTable(tableSegment);
        return this.sqlStats;
    }

    @Override
    public SQLStats visitTableWild(MySQLStatementParser.TableWildContext ctx) {
        ColumnSegment column = new ColumnSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), new IdentifierValue("*"));
        MySQLStatementParser.IdentifierContext owner = ctx.identifier().get(ctx.identifier().size() - 1);
        column.setOwner(new OwnerSegment(owner.start.getStartIndex(), owner.stop.getStopIndex(), new IdentifierValue(owner.getText())));
        this.sqlStats.addColumn(column);
        return this.sqlStats;
    }

    public SQLStats visitTerminal(TerminalNode node) {
        super.visitTerminal(node);
        return this.sqlStats;
    }

    @Generated
    public SQLStats getSqlStats() {
        return this.sqlStats;
    }
}

