/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.opengauss.visitor.statement.impl;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import lombok.Generated;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.autogen.OpenGaussStatementBaseVisitor;
import org.apache.shardingsphere.sql.parser.autogen.OpenGaussStatementParser;
import org.apache.shardingsphere.sql.parser.sql.common.constant.AggregationType;
import org.apache.shardingsphere.sql.parser.sql.common.constant.OrderDirection;
import org.apache.shardingsphere.sql.parser.sql.common.constant.ParameterMarkerType;
import org.apache.shardingsphere.sql.parser.sql.common.constant.UnionType;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.constraint.ConstraintSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.AssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.ColumnAssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.SetAssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.InsertColumnsSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.OnDuplicateKeyColumnsSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BetweenExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExistsSubqueryExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.InExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ListExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.complex.CommonExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubqueryExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.AggregationDistinctProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionsSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.SubqueryProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.GroupBySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.OrderBySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.ExpressionOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.IndexOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.OrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.PaginationValueSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.limit.LimitSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.limit.LimitValueSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.limit.NumberLiteralLimitValueSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.limit.ParameterMarkerLimitValueSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.HavingSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.LockSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.union.UnionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.AliasAvailable;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.AliasSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.DataTypeLengthSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.DataTypeSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.ParameterMarkerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.WindowSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.keyword.KeywordValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.literal.LiteralValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.literal.impl.BooleanLiteralValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.literal.impl.NumberLiteralValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.literal.impl.StringLiteralValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.parametermarker.ParameterMarkerValue;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussExecuteStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.dml.OpenGaussDeleteStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.dml.OpenGaussInsertStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.dml.OpenGaussSelectStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.dml.OpenGaussUpdateStatement;

public abstract class OpenGaussStatementSQLVisitor
extends OpenGaussStatementBaseVisitor<ASTNode> {
    private int currentParameterIndex;
    private final Collection<ParameterMarkerSegment> parameterMarkerSegments = new LinkedList<ParameterMarkerSegment>();

    public OpenGaussStatementSQLVisitor(Properties props) {
    }

    @Override
    public final ASTNode visitParameterMarker(OpenGaussStatementParser.ParameterMarkerContext ctx) {
        if (null != ctx.DOLLAR_()) {
            int parameterIndex = ((NumberLiteralValue)this.visit((ParseTree)ctx.numberLiterals())).getValue().intValue();
            if (parameterIndex > this.currentParameterIndex) {
                this.currentParameterIndex = parameterIndex;
            }
            return new ParameterMarkerValue(Integer.valueOf(parameterIndex - 1), ParameterMarkerType.DOLLAR);
        }
        return new ParameterMarkerValue(Integer.valueOf(this.currentParameterIndex++), ParameterMarkerType.QUESTION);
    }

    @Override
    public final ASTNode visitNumberLiterals(OpenGaussStatementParser.NumberLiteralsContext ctx) {
        return new NumberLiteralValue(ctx.getText());
    }

    @Override
    public final ASTNode visitIdentifier(OpenGaussStatementParser.IdentifierContext ctx) {
        OpenGaussStatementParser.UnreservedWordContext unreservedWord = ctx.unreservedWord();
        return null != unreservedWord ? (ASTNode)this.visit((ParseTree)unreservedWord) : new IdentifierValue(ctx.getText());
    }

    @Override
    public final ASTNode visitUnreservedWord(OpenGaussStatementParser.UnreservedWordContext ctx) {
        return new IdentifierValue(ctx.getText());
    }

    @Override
    public final ASTNode visitSchemaName(OpenGaussStatementParser.SchemaNameContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.identifier());
    }

    @Override
    public final ASTNode visitTableName(OpenGaussStatementParser.TableNameContext ctx) {
        SimpleTableSegment result = new SimpleTableSegment(new TableNameSegment(ctx.name().getStart().getStartIndex(), ctx.name().getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.name())));
        OpenGaussStatementParser.OwnerContext owner = ctx.owner();
        if (null != owner) {
            result.setOwner(new OwnerSegment(owner.getStart().getStartIndex(), owner.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)owner.identifier())));
        }
        return result;
    }

    @Override
    public final ASTNode visitColumnName(OpenGaussStatementParser.ColumnNameContext ctx) {
        ColumnSegment result = new ColumnSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.name()));
        OpenGaussStatementParser.OwnerContext owner = ctx.owner();
        if (null != owner) {
            result.setOwner(new OwnerSegment(owner.getStart().getStartIndex(), owner.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)owner.identifier())));
        }
        return result;
    }

    @Override
    public final ASTNode visitIndexName(OpenGaussStatementParser.IndexNameContext ctx) {
        return new IndexSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier()));
    }

    @Override
    public final ASTNode visitConstraintName(OpenGaussStatementParser.ConstraintNameContext ctx) {
        return new ConstraintSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier()));
    }

    @Override
    public final ASTNode visitTableNames(OpenGaussStatementParser.TableNamesContext ctx) {
        CollectionValue result = new CollectionValue();
        for (OpenGaussStatementParser.TableNameContext each : ctx.tableName()) {
            result.getValue().add((SimpleTableSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public final ASTNode visitColumnNames(OpenGaussStatementParser.ColumnNamesContext ctx) {
        CollectionValue result = new CollectionValue();
        for (OpenGaussStatementParser.ColumnNameContext each : ctx.columnName()) {
            result.getValue().add((ColumnSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitAExpr(OpenGaussStatementParser.AExprContext ctx) {
        if (null != ctx.cExpr()) {
            return (ASTNode)this.visit((ParseTree)ctx.cExpr());
        }
        if (null != ctx.BETWEEN()) {
            return this.createBetweenSegment(ctx);
        }
        if (null != ctx.IN()) {
            return this.createInSegment(ctx);
        }
        if (null != ctx.patternMatchingOperator()) {
            return this.createPatternMatchingOperationSegment(ctx);
        }
        if (null != ctx.comparisonOperator()) {
            return this.createCommonBinaryOperationSegment(ctx, ctx.comparisonOperator().getText());
        }
        if (null != ctx.andOperator()) {
            return this.createCommonBinaryOperationSegment(ctx, ctx.andOperator().getText());
        }
        if (null != ctx.orOperator()) {
            return this.createCommonBinaryOperationSegment(ctx, ctx.orOperator().getText());
        }
        super.visitAExpr(ctx);
        String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
        return new CommonExpressionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), text);
    }

    private BinaryOperationExpression createPatternMatchingOperationSegment(OpenGaussStatementParser.AExprContext ctx) {
        String operator = ctx.patternMatchingOperator().getText();
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.aExpr(0));
        ListExpression right = new ListExpression(ctx.aExpr((int)1).start.getStartIndex(), ctx.aExpr().get((int)(ctx.aExpr().size() - 1)).stop.getStopIndex());
        for (int i = 1; i < ctx.aExpr().size(); ++i) {
            right.getItems().add((ExpressionSegment)this.visit((ParseTree)ctx.aExpr().get(i)));
        }
        String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
        return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, (ExpressionSegment)right, operator, text);
    }

    private BinaryOperationExpression createCommonBinaryOperationSegment(OpenGaussStatementParser.AExprContext ctx, String operator) {
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.aExpr(0));
        ExpressionSegment right = (ExpressionSegment)this.visit((ParseTree)ctx.aExpr(1));
        String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
        return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, right, operator, text);
    }

    @Override
    public ASTNode visitCExpr(OpenGaussStatementParser.CExprContext ctx) {
        if (null != ctx.columnref()) {
            return (ASTNode)this.visit((ParseTree)ctx.columnref());
        }
        if (null != ctx.parameterMarker()) {
            ParameterMarkerValue parameterMarker = (ParameterMarkerValue)this.visit((ParseTree)ctx.parameterMarker());
            ParameterMarkerExpressionSegment segment = new ParameterMarkerExpressionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), parameterMarker.getValue().intValue(), parameterMarker.getType());
            this.parameterMarkerSegments.add((ParameterMarkerSegment)segment);
            return segment;
        }
        if (null != ctx.aexprConst()) {
            ASTNode astNode = (ASTNode)this.visit((ParseTree)ctx.aexprConst());
            if (astNode instanceof StringLiteralValue || astNode instanceof BooleanLiteralValue || astNode instanceof NumberLiteralValue) {
                return new LiteralExpressionSegment(ctx.aexprConst().start.getStartIndex(), ctx.aexprConst().stop.getStopIndex(), ((LiteralValue)astNode).getValue());
            }
            return astNode;
        }
        if (null != ctx.aExpr()) {
            return (ASTNode)this.visit((ParseTree)ctx.aExpr());
        }
        if (null != ctx.funcExpr()) {
            return (ASTNode)this.visit((ParseTree)ctx.funcExpr());
        }
        if (null != ctx.selectWithParens()) {
            return this.createSubqueryExpressionSegment(ctx);
        }
        super.visitCExpr(ctx);
        String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
        return new CommonExpressionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), text);
    }

    private ExpressionSegment createSubqueryExpressionSegment(OpenGaussStatementParser.CExprContext ctx) {
        SubquerySegment subquerySegment = new SubquerySegment(ctx.selectWithParens().getStart().getStartIndex(), ctx.selectWithParens().getStop().getStopIndex(), (SelectStatement)((OpenGaussSelectStatement)this.visit((ParseTree)ctx.selectWithParens())));
        if (null != ctx.EXISTS()) {
            return new ExistsSubqueryExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), subquerySegment);
        }
        return new SubqueryExpressionSegment(subquerySegment);
    }

    @Override
    public ASTNode visitFuncExpr(OpenGaussStatementParser.FuncExprContext ctx) {
        if (null != ctx.functionExprCommonSubexpr()) {
            return (ASTNode)this.visit((ParseTree)ctx.functionExprCommonSubexpr());
        }
        Collection<ExpressionSegment> expressionSegments = this.getExpressionSegments(this.getTargetRuleContextFromParseTree((ParseTree)ctx, OpenGaussStatementParser.CExprContext.class));
        String aggregationType = ctx.funcApplication().funcName().getText();
        if (AggregationType.isAggregationType((String)aggregationType)) {
            return this.createAggregationSegment(ctx.funcApplication(), aggregationType);
        }
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.funcApplication().funcName().getText(), this.getOriginalText(ctx));
        result.getParameters().addAll(expressionSegments);
        return result;
    }

    @Override
    public ASTNode visitFunctionExprCommonSubexpr(OpenGaussStatementParser.FunctionExprCommonSubexprContext ctx) {
        FunctionSegment result = new FunctionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getChild(0).getText(), this.getOriginalText(ctx));
        Collection<ExpressionSegment> expressionSegments = this.getExpressionSegments(this.getTargetRuleContextFromParseTree((ParseTree)ctx, OpenGaussStatementParser.CExprContext.class));
        result.getParameters().addAll(expressionSegments);
        return result;
    }

    private <T extends ParseTree> Collection<T> getTargetRuleContextFromParseTree(ParseTree parseTree, Class<? extends T> clazz) {
        LinkedList<Object> result = new LinkedList<Object>();
        for (int index = 0; index < parseTree.getChildCount(); ++index) {
            ParseTree child = parseTree.getChild(index);
            if (clazz.isInstance(child)) {
                result.add(clazz.cast(child));
                continue;
            }
            result.addAll(this.getTargetRuleContextFromParseTree(child, clazz));
        }
        return result;
    }

    private Collection<ExpressionSegment> getExpressionSegments(Collection<OpenGaussStatementParser.CExprContext> cexprContexts) {
        LinkedList<ExpressionSegment> result = new LinkedList<ExpressionSegment>();
        for (OpenGaussStatementParser.CExprContext each : cexprContexts) {
            result.add((ExpressionSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitAexprConst(OpenGaussStatementParser.AexprConstContext ctx) {
        if (null != ctx.NUMBER_()) {
            return new NumberLiteralValue(ctx.NUMBER_().getText());
        }
        if (null != ctx.STRING_()) {
            return new StringLiteralValue(ctx.STRING_().getText());
        }
        if (null != ctx.FALSE()) {
            return new BooleanLiteralValue(ctx.FALSE().getText());
        }
        if (null != ctx.TRUE()) {
            return new BooleanLiteralValue(ctx.TRUE().getText());
        }
        return new CommonExpressionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), ctx.getText());
    }

    @Override
    public ASTNode visitColumnref(OpenGaussStatementParser.ColumnrefContext ctx) {
        if (null != ctx.indirection()) {
            OpenGaussStatementParser.AttrNameContext attrName = ctx.indirection().indirectionEl().attrName();
            ColumnSegment result = new ColumnSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), new IdentifierValue(attrName.getText()));
            OwnerSegment owner = new OwnerSegment(ctx.colId().start.getStartIndex(), ctx.colId().stop.getStopIndex(), new IdentifierValue(ctx.colId().getText()));
            result.setOwner(owner);
            return result;
        }
        return new ColumnSegment(ctx.colId().start.getStartIndex(), ctx.colId().stop.getStopIndex(), new IdentifierValue(ctx.colId().getText()));
    }

    private InExpression createInSegment(OpenGaussStatementParser.AExprContext ctx) {
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.aExpr(0));
        ExpressionSegment right = this.createInExpressionSegment(ctx.inExpr());
        boolean not = null != ctx.NOT();
        return new InExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, right, not);
    }

    private ExpressionSegment createInExpressionSegment(OpenGaussStatementParser.InExprContext ctx) {
        if (null != ctx.selectWithParens()) {
            OpenGaussSelectStatement select = (OpenGaussSelectStatement)this.visit((ParseTree)ctx.selectWithParens());
            SubquerySegment subquerySegment = new SubquerySegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (SelectStatement)select);
            return new SubqueryExpressionSegment(subquerySegment);
        }
        ListExpression result = new ListExpression(ctx.LP_().getSymbol().getStartIndex(), ctx.RP_().getSymbol().getStopIndex());
        result.getItems().addAll(((CollectionValue)this.visit((ParseTree)ctx.exprList())).getValue());
        return result;
    }

    @Override
    public ASTNode visitExprList(OpenGaussStatementParser.ExprListContext ctx) {
        CollectionValue result = new CollectionValue();
        if (null != ctx.exprList()) {
            result.combine((CollectionValue)this.visitExprList(ctx.exprList()));
        }
        result.getValue().add((ExpressionSegment)this.visit((ParseTree)ctx.aExpr()));
        return result;
    }

    private BetweenExpression createBetweenSegment(OpenGaussStatementParser.AExprContext ctx) {
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.aExpr(0));
        ExpressionSegment between = (ExpressionSegment)this.visit((ParseTree)ctx.bExpr());
        ExpressionSegment and = (ExpressionSegment)this.visit((ParseTree)ctx.aExpr(1));
        boolean not = null != ctx.NOT();
        return new BetweenExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, between, and, not);
    }

    @Override
    public ASTNode visitBExpr(OpenGaussStatementParser.BExprContext ctx) {
        if (null != ctx.cExpr()) {
            return (ASTNode)this.visit((ParseTree)ctx.cExpr());
        }
        if (null != ctx.TYPE_CAST_() || null != ctx.qualOp()) {
            ExpressionSegment right;
            String operator;
            ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.bExpr(0));
            if (null != ctx.TYPE_CAST_()) {
                operator = ctx.TYPE_CAST_().getText();
                right = new CommonExpressionSegment(ctx.typeName().start.getStartIndex(), ctx.typeName().stop.getStopIndex(), ctx.typeName().getText());
            } else {
                operator = ctx.qualOp().getText();
                right = (ExpressionSegment)this.visit((ParseTree)ctx.bExpr(1));
            }
            String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
            return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, right, operator, text);
        }
        for (OpenGaussStatementParser.BExprContext each : ctx.bExpr()) {
            this.visit((ParseTree)each);
        }
        return new LiteralExpressionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (Object)ctx.getText());
    }

    private ProjectionSegment createAggregationSegment(OpenGaussStatementParser.FuncApplicationContext ctx, String aggregationType) {
        AggregationType type = AggregationType.valueOf((String)aggregationType.toUpperCase());
        String innerExpression = ctx.start.getInputStream().getText(new Interval(ctx.LP_().getSymbol().getStartIndex(), ctx.stop.getStopIndex()));
        if (null == ctx.DISTINCT()) {
            return new AggregationProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), type, innerExpression);
        }
        return new AggregationDistinctProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), type, innerExpression, this.getDistinctExpression(ctx));
    }

    private String getDistinctExpression(OpenGaussStatementParser.FuncApplicationContext ctx) {
        StringBuilder result = new StringBuilder();
        result.append(ctx.funcArgList().getText());
        if (null != ctx.sortClause()) {
            result.append(ctx.sortClause().getText());
        }
        return result.toString();
    }

    @Override
    public final ASTNode visitDataTypeName(OpenGaussStatementParser.DataTypeNameContext ctx) {
        OpenGaussStatementParser.IdentifierContext identifierContext = ctx.identifier();
        if (null != identifierContext) {
            return new KeywordValue(identifierContext.getText());
        }
        LinkedList<String> dataTypeNames = new LinkedList<String>();
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            dataTypeNames.add(ctx.getChild(i).getText());
        }
        return new KeywordValue(Joiner.on((String)" ").join(dataTypeNames));
    }

    @Override
    public final ASTNode visitSortClause(OpenGaussStatementParser.SortClauseContext ctx) {
        LinkedList<OrderByItemSegment> items = new LinkedList<OrderByItemSegment>();
        for (OpenGaussStatementParser.SortbyContext each : ctx.sortbyList().sortby()) {
            items.add((OrderByItemSegment)this.visit((ParseTree)each));
        }
        return new OrderBySegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), items);
    }

    @Override
    public final ASTNode visitSortby(OpenGaussStatementParser.SortbyContext ctx) {
        OrderDirection orderDirection = null != ctx.ascDesc() ? this.generateOrderDirection(ctx.ascDesc()) : OrderDirection.ASC;
        ASTNode expr = (ASTNode)this.visit((ParseTree)ctx.aExpr());
        if (expr instanceof ColumnSegment) {
            ColumnSegment column = (ColumnSegment)expr;
            return new ColumnOrderByItemSegment(column, orderDirection);
        }
        if (expr instanceof LiteralExpressionSegment) {
            LiteralExpressionSegment index = (LiteralExpressionSegment)expr;
            return new IndexOrderByItemSegment(index.getStartIndex(), index.getStopIndex(), Integer.parseInt(index.getLiterals().toString()), orderDirection);
        }
        if (expr instanceof ExpressionSegment) {
            return new ExpressionOrderByItemSegment(ctx.aExpr().getStart().getStartIndex(), ctx.aExpr().getStop().getStopIndex(), this.getOriginalText(ctx.aExpr()), orderDirection, (ExpressionSegment)expr);
        }
        return new ExpressionOrderByItemSegment(ctx.aExpr().getStart().getStartIndex(), ctx.aExpr().getStop().getStopIndex(), this.getOriginalText(ctx.aExpr()), orderDirection);
    }

    private OrderDirection generateOrderDirection(OpenGaussStatementParser.AscDescContext ctx) {
        return null == ctx.DESC() ? OrderDirection.ASC : OrderDirection.DESC;
    }

    @Override
    public final ASTNode visitDataType(OpenGaussStatementParser.DataTypeContext ctx) {
        DataTypeSegment result = new DataTypeSegment();
        result.setDataTypeName(((KeywordValue)this.visit((ParseTree)ctx.dataTypeName())).getValue());
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        if (null != ctx.dataTypeLength()) {
            DataTypeLengthSegment dataTypeLengthSegment = (DataTypeLengthSegment)this.visit((ParseTree)ctx.dataTypeLength());
            result.setDataLength(dataTypeLengthSegment);
        }
        return result;
    }

    @Override
    public final ASTNode visitDataTypeLength(OpenGaussStatementParser.DataTypeLengthContext ctx) {
        DataTypeLengthSegment result = new DataTypeLengthSegment();
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStartIndex());
        List<TerminalNode> numbers = ctx.NUMBER_();
        if (1 == numbers.size()) {
            result.setPrecision(Integer.parseInt(numbers.get(0).getText()));
        }
        if (2 == numbers.size()) {
            result.setPrecision(Integer.parseInt(numbers.get(0).getText()));
            result.setScale(Integer.parseInt(numbers.get(1).getText()));
        }
        return result;
    }

    @Override
    public ASTNode visitInsert(OpenGaussStatementParser.InsertContext ctx) {
        OpenGaussInsertStatement result = (OpenGaussInsertStatement)this.visit((ParseTree)ctx.insertRest());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.insertTarget()));
        if (null != ctx.optOnDuplicateKey()) {
            result.setOnDuplicateKeyColumnsSegment((OnDuplicateKeyColumnsSegment)this.visit((ParseTree)ctx.optOnDuplicateKey()));
        }
        result.setParameterCount(this.getCurrentParameterIndex());
        result.getParameterMarkerSegments().addAll(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitInsertTarget(OpenGaussStatementParser.InsertTargetContext ctx) {
        TableNameSegment tableName;
        OpenGaussStatementParser.QualifiedNameContext qualifiedName = ctx.qualifiedName();
        OwnerSegment owner = null;
        if (null != qualifiedName.indirection()) {
            OpenGaussStatementParser.ColIdContext colId = ctx.qualifiedName().colId();
            owner = new OwnerSegment(colId.start.getStartIndex(), colId.stop.getStopIndex(), new IdentifierValue(colId.getText()));
            OpenGaussStatementParser.AttrNameContext attrName = qualifiedName.indirection().indirectionEl().attrName();
            tableName = new TableNameSegment(attrName.start.getStartIndex(), attrName.stop.getStopIndex(), new IdentifierValue(attrName.getText()));
        } else {
            tableName = new TableNameSegment(qualifiedName.colId().start.getStartIndex(), qualifiedName.colId().stop.getStopIndex(), new IdentifierValue(qualifiedName.colId().getText()));
        }
        SimpleTableSegment result = new SimpleTableSegment(tableName);
        result.setOwner(owner);
        if (null != ctx.AS()) {
            OpenGaussStatementParser.ColIdContext colId = ctx.colId();
            result.setAlias(new AliasSegment(colId.start.getStartIndex(), colId.stop.getStopIndex(), new IdentifierValue(colId.getText())));
        }
        return result;
    }

    @Override
    public ASTNode visitInsertRest(OpenGaussStatementParser.InsertRestContext ctx) {
        OpenGaussInsertStatement result = new OpenGaussInsertStatement();
        if (null != ctx.insertColumnList()) {
            OpenGaussStatementParser.InsertColumnListContext insertColumns = ctx.insertColumnList();
            CollectionValue columns = (CollectionValue)this.visit((ParseTree)insertColumns);
            InsertColumnsSegment insertColumnsSegment = new InsertColumnsSegment(insertColumns.start.getStartIndex() - 1, insertColumns.stop.getStopIndex() + 1, columns.getValue());
            result.setInsertColumns(insertColumnsSegment);
        } else {
            result.setInsertColumns(new InsertColumnsSegment(ctx.start.getStartIndex() - 1, ctx.start.getStartIndex() - 1, Collections.emptyList()));
        }
        OpenGaussStatementParser.ValuesClauseContext valuesClause = ctx.select().selectNoParens().selectClauseN().simpleSelect().valuesClause();
        Collection<InsertValuesSegment> insertValuesSegments = this.createInsertValuesSegments(valuesClause);
        result.getValues().addAll(insertValuesSegments);
        return result;
    }

    @Override
    public ASTNode visitOptOnDuplicateKey(OpenGaussStatementParser.OptOnDuplicateKeyContext ctx) {
        if (null != ctx.NOTHING()) {
            return new OnDuplicateKeyColumnsSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), Collections.emptyList());
        }
        LinkedList<AssignmentSegment> columns = new LinkedList<AssignmentSegment>();
        for (OpenGaussStatementParser.AssignmentContext each : ctx.assignment()) {
            columns.add((AssignmentSegment)this.visit((ParseTree)each));
        }
        return new OnDuplicateKeyColumnsSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columns);
    }

    @Override
    public ASTNode visitAssignment(OpenGaussStatementParser.AssignmentContext ctx) {
        ExpressionSegment expressionSegment;
        List<ColumnSegment> columnSegments = Collections.singletonList((ColumnSegment)this.visit((ParseTree)ctx.setTarget()));
        if (null != ctx.aExpr()) {
            expressionSegment = (ExpressionSegment)this.visit((ParseTree)ctx.aExpr());
        } else {
            String value = ctx.start.getInputStream().getText(new Interval(ctx.VALUES().getSymbol().getStartIndex(), ctx.stop.getStopIndex()));
            FunctionSegment functionSegment = new FunctionSegment(ctx.VALUES().getSymbol().getStartIndex(), ctx.getStop().getStopIndex(), ctx.VALUES().getText(), value);
            functionSegment.getParameters().add(new ColumnSegment(ctx.name().getStart().getStartIndex(), ctx.name().getStop().getStopIndex(), new IdentifierValue(ctx.name().getText())));
            expressionSegment = functionSegment;
        }
        return new ColumnAssignmentSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), columnSegments, expressionSegment);
    }

    @Override
    public ASTNode visitInsertColumnList(OpenGaussStatementParser.InsertColumnListContext ctx) {
        CollectionValue result = new CollectionValue();
        if (null != ctx.insertColumnList()) {
            result.getValue().addAll(((CollectionValue)this.visit((ParseTree)ctx.insertColumnList())).getValue());
        }
        result.getValue().add((ColumnSegment)this.visit((ParseTree)ctx.insertColumnItem()));
        return result;
    }

    @Override
    public ASTNode visitInsertColumnItem(OpenGaussStatementParser.InsertColumnItemContext ctx) {
        if (null != ctx.optIndirection().indirectionEl()) {
            ColumnSegment result = new ColumnSegment(ctx.colId().start.getStartIndex(), ctx.optIndirection().stop.getStopIndex(), new IdentifierValue(ctx.optIndirection().indirectionEl().attrName().getText()));
            result.setOwner(new OwnerSegment(ctx.colId().start.getStartIndex(), ctx.colId().stop.getStopIndex(), new IdentifierValue(ctx.colId().getText())));
            return result;
        }
        return new ColumnSegment(ctx.colId().start.getStartIndex(), ctx.colId().stop.getStopIndex(), new IdentifierValue(ctx.colId().getText()));
    }

    private Collection<InsertValuesSegment> createInsertValuesSegments(OpenGaussStatementParser.ValuesClauseContext ctx) {
        Collection<InsertValuesSegment> expressions;
        LinkedList<InsertValuesSegment> result = new LinkedList<InsertValuesSegment>();
        if (null != ctx.valuesClause()) {
            expressions = this.createInsertValuesSegments(ctx.valuesClause());
            result.addAll(expressions);
        }
        expressions = this.createInsertValuesSegments(ctx.exprList());
        InsertValuesSegment insertValuesSegment = new InsertValuesSegment(ctx.LP_().getSymbol().getStartIndex(), ctx.RP_().getSymbol().getStopIndex(), (List)expressions);
        result.add(insertValuesSegment);
        return result;
    }

    private Collection<ExpressionSegment> createInsertValuesSegments(OpenGaussStatementParser.ExprListContext ctx) {
        LinkedList<ExpressionSegment> result = new LinkedList<ExpressionSegment>();
        if (null != ctx.exprList()) {
            Collection<ExpressionSegment> tmpResult = this.createInsertValuesSegments(ctx.exprList());
            result.addAll(tmpResult);
        }
        ExpressionSegment expr = (ExpressionSegment)this.visit((ParseTree)ctx.aExpr());
        result.add(expr);
        return result;
    }

    private Collection<AssignmentSegment> generateAssignmentSegments(OpenGaussStatementParser.SetClauseListContext ctx) {
        LinkedList<AssignmentSegment> result = new LinkedList<AssignmentSegment>();
        if (null != ctx.setClauseList()) {
            Collection<AssignmentSegment> tmpResult = this.generateAssignmentSegments(ctx.setClauseList());
            result.addAll(tmpResult);
        }
        AssignmentSegment assignmentSegment = (AssignmentSegment)this.visit((ParseTree)ctx.setClause());
        result.add(assignmentSegment);
        return result;
    }

    @Override
    public ASTNode visitSetClause(OpenGaussStatementParser.SetClauseContext ctx) {
        ColumnSegment columnSegment = (ColumnSegment)this.visit((ParseTree)ctx.setTarget());
        LinkedList<ColumnSegment> columnSegments = new LinkedList<ColumnSegment>();
        columnSegments.add(columnSegment);
        ExpressionSegment expressionSegment = (ExpressionSegment)this.visit((ParseTree)ctx.aExpr());
        return new ColumnAssignmentSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), columnSegments, expressionSegment);
    }

    @Override
    public ASTNode visitSetTarget(OpenGaussStatementParser.SetTargetContext ctx) {
        IdentifierValue identifierValue = new IdentifierValue(ctx.colId().getText());
        return new ColumnSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), identifierValue);
    }

    @Override
    public ASTNode visitRelationExprOptAlias(OpenGaussStatementParser.RelationExprOptAliasContext ctx) {
        SimpleTableSegment result = this.createTableFromRelationExpr(ctx.relationExpr());
        if (null != ctx.colId()) {
            result.setAlias(new AliasSegment(ctx.colId().start.getStartIndex(), ctx.stop.getStopIndex(), new IdentifierValue(ctx.colId().getText())));
        }
        return result;
    }

    @Override
    public ASTNode visitUpdate(OpenGaussStatementParser.UpdateContext ctx) {
        OpenGaussUpdateStatement result = new OpenGaussUpdateStatement();
        SimpleTableSegment tableSegment = (SimpleTableSegment)this.visit((ParseTree)ctx.relationExprOptAlias());
        result.setTableSegment((TableSegment)tableSegment);
        result.setSetAssignment((SetAssignmentSegment)this.visit((ParseTree)ctx.setClauseList()));
        if (null != ctx.whereOrCurrentClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.whereOrCurrentClause()));
        }
        result.setParameterCount(this.getCurrentParameterIndex());
        result.getParameterMarkerSegments().addAll(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitSetClauseList(OpenGaussStatementParser.SetClauseListContext ctx) {
        Collection<AssignmentSegment> assignments = this.generateAssignmentSegments(ctx);
        return new SetAssignmentSegment(ctx.start.getStartIndex() - 4, ctx.stop.getStopIndex(), assignments);
    }

    @Override
    public ASTNode visitDelete(OpenGaussStatementParser.DeleteContext ctx) {
        OpenGaussDeleteStatement result = new OpenGaussDeleteStatement();
        SimpleTableSegment tableSegment = (SimpleTableSegment)this.visit((ParseTree)ctx.relationExprOptAlias());
        result.setTableSegment((TableSegment)tableSegment);
        if (null != ctx.whereOrCurrentClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.whereOrCurrentClause()));
        }
        result.setParameterCount(this.getCurrentParameterIndex());
        result.getParameterMarkerSegments().addAll(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitWhereOrCurrentClause(OpenGaussStatementParser.WhereOrCurrentClauseContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.whereClause());
    }

    @Override
    public ASTNode visitSelect(OpenGaussStatementParser.SelectContext ctx) {
        OpenGaussSelectStatement result = (OpenGaussSelectStatement)this.visit((ParseTree)ctx.selectNoParens());
        result.setParameterCount(this.getCurrentParameterIndex());
        result.getParameterMarkerSegments().addAll(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitSelectNoParens(OpenGaussStatementParser.SelectNoParensContext ctx) {
        OpenGaussSelectStatement result = (OpenGaussSelectStatement)this.visit((ParseTree)ctx.selectClauseN());
        if (null != ctx.sortClause()) {
            OrderBySegment orderBySegment = (OrderBySegment)this.visit((ParseTree)ctx.sortClause());
            result.setOrderBy(orderBySegment);
        }
        if (null != ctx.selectLimit()) {
            LimitSegment limitSegment = (LimitSegment)this.visit((ParseTree)ctx.selectLimit());
            result.setLimit(limitSegment);
        }
        if (null != ctx.forLockingClause()) {
            LockSegment lockSegment = (LockSegment)this.visit((ParseTree)ctx.forLockingClause());
            result.setLock(lockSegment);
        }
        return result;
    }

    @Override
    public ASTNode visitForLockingClause(OpenGaussStatementParser.ForLockingClauseContext ctx) {
        return new LockSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
    }

    @Override
    public ASTNode visitSelectWithParens(OpenGaussStatementParser.SelectWithParensContext ctx) {
        if (null != ctx.selectWithParens()) {
            return (ASTNode)this.visit((ParseTree)ctx.selectWithParens());
        }
        return (ASTNode)this.visit((ParseTree)ctx.selectNoParens());
    }

    @Override
    public ASTNode visitSelectClauseN(OpenGaussStatementParser.SelectClauseNContext ctx) {
        if (null != ctx.simpleSelect()) {
            return (ASTNode)this.visit((ParseTree)ctx.simpleSelect());
        }
        if (null != ctx.selectClauseN() && !ctx.selectClauseN().isEmpty()) {
            OpenGaussSelectStatement result = (OpenGaussSelectStatement)this.visit((ParseTree)ctx.selectClauseN(0));
            UnionSegment unionSegment = new UnionSegment(this.getUnionType(ctx), (SelectStatement)((OpenGaussSelectStatement)this.visit((ParseTree)ctx.selectClauseN(1))), ((TerminalNode)ctx.getChild(1)).getSymbol().getStartIndex(), ctx.getStop().getStopIndex());
            result.getUnionSegments().add(unionSegment);
            return result;
        }
        return (ASTNode)this.visit((ParseTree)ctx.selectWithParens());
    }

    private UnionType getUnionType(OpenGaussStatementParser.SelectClauseNContext ctx) {
        boolean isDistinct;
        boolean bl = isDistinct = null == ctx.allOrDistinct() || null != ctx.allOrDistinct().DISTINCT();
        if (null != ctx.UNION()) {
            return isDistinct ? UnionType.UNION_DISTINCT : UnionType.UNION_ALL;
        }
        if (null != ctx.INTERSECT()) {
            return isDistinct ? UnionType.INTERSECT_DISTINCT : UnionType.INTERSECT_ALL;
        }
        if (null != ctx.MINUS()) {
            return isDistinct ? UnionType.MINUS_DISTINCT : UnionType.MINUS_ALL;
        }
        return isDistinct ? UnionType.EXCEPT_DISTINCT : UnionType.EXCEPT_ALL;
    }

    @Override
    public ASTNode visitSimpleSelect(OpenGaussStatementParser.SimpleSelectContext ctx) {
        OpenGaussSelectStatement result = new OpenGaussSelectStatement();
        if (null != ctx.targetList()) {
            ProjectionsSegment projects = (ProjectionsSegment)this.visit((ParseTree)ctx.targetList());
            if (null != ctx.distinctClause()) {
                projects.setDistinctRow(true);
            }
            result.setProjections(projects);
        } else {
            result.setProjections(new ProjectionsSegment(-1, -1));
        }
        if (null != ctx.fromClause()) {
            TableSegment tableSegment = (TableSegment)this.visit((ParseTree)ctx.fromClause());
            result.setFrom(tableSegment);
        }
        if (null != ctx.whereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.whereClause()));
        }
        if (null != ctx.groupClause()) {
            result.setGroupBy((GroupBySegment)this.visit((ParseTree)ctx.groupClause()));
        }
        if (null != ctx.havingClause()) {
            result.setHaving((HavingSegment)this.visit((ParseTree)ctx.havingClause()));
        }
        if (null != ctx.windowClause()) {
            result.setWindow((WindowSegment)this.visit((ParseTree)ctx.windowClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitHavingClause(OpenGaussStatementParser.HavingClauseContext ctx) {
        ExpressionSegment expr = (ExpressionSegment)this.visit((ParseTree)ctx.aExpr());
        return new HavingSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), expr);
    }

    @Override
    public ASTNode visitWindowClause(OpenGaussStatementParser.WindowClauseContext ctx) {
        return new WindowSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
    }

    @Override
    public ASTNode visitGroupClause(OpenGaussStatementParser.GroupClauseContext ctx) {
        LinkedList<OrderByItemSegment> items = new LinkedList<OrderByItemSegment>();
        for (OpenGaussStatementParser.GroupByItemContext each : ctx.groupByList().groupByItem()) {
            items.add((OrderByItemSegment)this.visit((ParseTree)each));
        }
        return new GroupBySegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), items);
    }

    @Override
    public ASTNode visitGroupByItem(OpenGaussStatementParser.GroupByItemContext ctx) {
        if (null != ctx.aExpr()) {
            ASTNode astNode = (ASTNode)this.visit((ParseTree)ctx.aExpr());
            if (astNode instanceof ColumnSegment) {
                return new ColumnOrderByItemSegment((ColumnSegment)astNode, OrderDirection.ASC);
            }
            if (astNode instanceof LiteralExpressionSegment) {
                LiteralExpressionSegment index = (LiteralExpressionSegment)astNode;
                return new IndexOrderByItemSegment(index.getStartIndex(), index.getStopIndex(), Integer.parseInt(index.getLiterals().toString()), OrderDirection.ASC);
            }
            return new ExpressionOrderByItemSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), this.getOriginalText(ctx), OrderDirection.ASC);
        }
        return new ExpressionOrderByItemSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), this.getOriginalText(ctx), OrderDirection.ASC);
    }

    @Override
    public ASTNode visitTargetList(OpenGaussStatementParser.TargetListContext ctx) {
        ProjectionsSegment result = new ProjectionsSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        if (null != ctx.targetList()) {
            ProjectionsSegment projections = (ProjectionsSegment)this.visit((ParseTree)ctx.targetList());
            result.getProjections().addAll(projections.getProjections());
        }
        ProjectionSegment projection = (ProjectionSegment)this.visit((ParseTree)ctx.targetEl());
        result.getProjections().add(projection);
        return result;
    }

    @Override
    public ASTNode visitTargetEl(OpenGaussStatementParser.TargetElContext ctx) {
        if (null != ctx.ASTERISK_()) {
            return new ShorthandProjectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        }
        if (null != ctx.DOT_ASTERISK_()) {
            ShorthandProjectionSegment shorthandProjection = new ShorthandProjectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
            shorthandProjection.setOwner(new OwnerSegment(ctx.colId().start.getStartIndex(), ctx.colId().stop.getStopIndex(), new IdentifierValue(ctx.colId().getText())));
            return shorthandProjection;
        }
        OpenGaussStatementParser.AExprContext expr = ctx.aExpr();
        ExpressionProjectionSegment result = new ExpressionProjectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), this.getOriginalText(expr));
        if (null != expr.cExpr()) {
            String text;
            ASTNode projection = (ASTNode)this.visit((ParseTree)expr.cExpr());
            if (projection instanceof ColumnSegment) {
                result = new ColumnProjectionSegment((ColumnSegment)projection);
            }
            if (projection instanceof FunctionSegment) {
                result = new ExpressionProjectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), this.getOriginalText(expr), (ExpressionSegment)((FunctionSegment)projection));
            }
            if (projection instanceof AggregationProjectionSegment) {
                result = (AggregationProjectionSegment)projection;
            }
            if (projection instanceof SubqueryExpressionSegment) {
                SubqueryExpressionSegment subqueryExpression = (SubqueryExpressionSegment)projection;
                text = ctx.start.getInputStream().getText(new Interval(subqueryExpression.getStartIndex(), subqueryExpression.getStopIndex()));
                result = new SubqueryProjectionSegment(subqueryExpression.getSubquery(), text);
            }
            if (projection instanceof ExistsSubqueryExpression) {
                ExistsSubqueryExpression existsSubqueryExpression = (ExistsSubqueryExpression)projection;
                text = ctx.start.getInputStream().getText(new Interval(existsSubqueryExpression.getStartIndex(), existsSubqueryExpression.getStopIndex()));
                result = new SubqueryProjectionSegment(existsSubqueryExpression.getSubquery(), text);
            }
        }
        if (result instanceof AliasAvailable && null != ctx.identifier()) {
            ((AliasAvailable)result).setAlias(new AliasSegment(ctx.identifier().start.getStartIndex(), ctx.identifier().stop.getStopIndex(), new IdentifierValue(ctx.identifier().getText())));
        }
        return result;
    }

    @Override
    public ASTNode visitFromClause(OpenGaussStatementParser.FromClauseContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.fromList());
    }

    @Override
    public ASTNode visitFromList(OpenGaussStatementParser.FromListContext ctx) {
        if (null != ctx.fromList()) {
            JoinTableSegment result = new JoinTableSegment();
            result.setStartIndex(ctx.start.getStartIndex());
            result.setStopIndex(ctx.stop.getStopIndex());
            result.setLeft((TableSegment)this.visit((ParseTree)ctx.fromList()));
            result.setRight((TableSegment)this.visit((ParseTree)ctx.tableReference()));
            return result;
        }
        return (ASTNode)this.visit((ParseTree)ctx.tableReference());
    }

    @Override
    public ASTNode visitTableReference(OpenGaussStatementParser.TableReferenceContext ctx) {
        if (null != ctx.relationExpr()) {
            SimpleTableSegment result = this.createTableFromRelationExpr(ctx.relationExpr());
            if (null != ctx.aliasClause()) {
                result.setAlias((AliasSegment)this.visit((ParseTree)ctx.aliasClause()));
            }
            return result;
        }
        if (null != ctx.selectWithParens()) {
            OpenGaussSelectStatement select = (OpenGaussSelectStatement)this.visit((ParseTree)ctx.selectWithParens());
            SubquerySegment subquery = new SubquerySegment(ctx.selectWithParens().start.getStartIndex(), ctx.selectWithParens().stop.getStopIndex(), (SelectStatement)select);
            AliasSegment alias = null != ctx.aliasClause() ? (AliasSegment)this.visit((ParseTree)ctx.aliasClause()) : null;
            SubqueryTableSegment result = new SubqueryTableSegment(subquery);
            result.setAlias(alias);
            return result;
        }
        if (null != ctx.tableReference()) {
            JoinTableSegment result = new JoinTableSegment();
            result.setLeft((TableSegment)this.visit((ParseTree)ctx.tableReference()));
            int startIndex = null != ctx.LP_() ? ctx.LP_().getSymbol().getStartIndex() : ctx.tableReference().start.getStartIndex();
            int stopIndex = 0;
            AliasSegment alias = null;
            if (null != ctx.aliasClause()) {
                alias = (AliasSegment)this.visit((ParseTree)ctx.aliasClause());
                startIndex = null != ctx.RP_() ? ctx.RP_().getSymbol().getStopIndex() : ctx.joinedTable().stop.getStopIndex();
            } else {
                stopIndex = null != ctx.RP_() ? ctx.RP_().getSymbol().getStopIndex() : ctx.tableReference().start.getStopIndex();
            }
            result.setStartIndex(startIndex);
            result.setStopIndex(stopIndex);
            result = this.visitJoinedTable(ctx.joinedTable(), result);
            result.setAlias(alias);
            return result;
        }
        TableNameSegment tableName = new TableNameSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), new IdentifierValue("not support"));
        return new SimpleTableSegment(tableName);
    }

    private JoinTableSegment visitJoinedTable(OpenGaussStatementParser.JoinedTableContext ctx, JoinTableSegment tableSegment) {
        JoinTableSegment result = tableSegment;
        TableSegment right = (TableSegment)this.visit((ParseTree)ctx.tableReference());
        result.setRight(right);
        if (null != ctx.joinQual()) {
            result = this.visitJoinQual(ctx.joinQual(), result);
        }
        return result;
    }

    private JoinTableSegment visitJoinQual(OpenGaussStatementParser.JoinQualContext ctx, JoinTableSegment joinTableSource) {
        if (null != ctx.aExpr()) {
            ExpressionSegment condition = (ExpressionSegment)this.visit((ParseTree)ctx.aExpr());
            joinTableSource.setCondition(condition);
        }
        if (null != ctx.USING()) {
            joinTableSource.setUsing(this.generateUsingColumn(ctx.nameList()));
        }
        return joinTableSource;
    }

    private List<ColumnSegment> generateUsingColumn(OpenGaussStatementParser.NameListContext ctx) {
        LinkedList<ColumnSegment> result = new LinkedList<ColumnSegment>();
        if (null != ctx.nameList()) {
            result.addAll(this.generateUsingColumn(ctx.nameList()));
        }
        if (null != ctx.name()) {
            ColumnSegment column = new ColumnSegment(ctx.name().start.getStartIndex(), ctx.name().stop.getStopIndex(), new IdentifierValue(ctx.name().getText()));
            result.add(column);
        }
        return result;
    }

    @Override
    public ASTNode visitAliasClause(OpenGaussStatementParser.AliasClauseContext ctx) {
        StringBuilder aliasName = new StringBuilder(ctx.colId().getText());
        if (null != ctx.nameList()) {
            aliasName.append(ctx.LP_().getText());
            aliasName.append(ctx.nameList().getText());
            aliasName.append(ctx.RP_().getText());
        }
        return new AliasSegment(ctx.colId().start.getStartIndex(), ctx.stop.getStopIndex(), new IdentifierValue(aliasName.toString()));
    }

    private SimpleTableSegment createTableFromRelationExpr(OpenGaussStatementParser.RelationExprContext ctx) {
        OpenGaussStatementParser.QualifiedNameContext qualifiedName = ctx.qualifiedName();
        if (null != qualifiedName.indirection()) {
            OpenGaussStatementParser.AttrNameContext tableName = qualifiedName.indirection().indirectionEl().attrName();
            SimpleTableSegment table = new SimpleTableSegment(new TableNameSegment(tableName.start.getStartIndex(), tableName.stop.getStopIndex(), new IdentifierValue(tableName.getText())));
            OwnerSegment owner = new OwnerSegment(qualifiedName.colId().start.getStartIndex(), qualifiedName.colId().stop.getStopIndex(), new IdentifierValue(qualifiedName.colId().getText()));
            if (null != qualifiedName.indirection().indirection()) {
                OwnerSegment tableOwner = this.createTableOwner(qualifiedName.indirection().indirection());
                tableOwner.setOwner(owner);
                table.setOwner(tableOwner);
            } else {
                table.setOwner(owner);
            }
            return table;
        }
        return new SimpleTableSegment(new TableNameSegment(qualifiedName.colId().start.getStartIndex(), qualifiedName.colId().stop.getStopIndex(), new IdentifierValue(qualifiedName.colId().getText())));
    }

    private OwnerSegment createTableOwner(OpenGaussStatementParser.IndirectionContext ctx) {
        OpenGaussStatementParser.AttrNameContext attrName = ctx.indirectionEl().attrName();
        return new OwnerSegment(attrName.start.getStartIndex(), attrName.stop.getStopIndex(), new IdentifierValue(attrName.getText()));
    }

    @Override
    public ASTNode visitWhereClause(OpenGaussStatementParser.WhereClauseContext ctx) {
        ExpressionSegment expr = (ExpressionSegment)this.visit((ParseTree)ctx.aExpr());
        return new WhereSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), expr);
    }

    @Override
    public ASTNode visitSelectLimit(OpenGaussStatementParser.SelectLimitContext ctx) {
        if (null != ctx.limitClause() && null != ctx.offsetClause()) {
            return this.createLimitSegmentWhenLimitAndOffset(ctx);
        }
        return this.createLimitSegmentWhenRowCountOrOffsetAbsent(ctx);
    }

    @Override
    public ASTNode visitSelectLimitValue(OpenGaussStatementParser.SelectLimitValueContext ctx) {
        if (null != ctx.ALL()) {
            return null;
        }
        ASTNode astNode = (ASTNode)this.visit((ParseTree)ctx.aExpr());
        if (astNode instanceof ParameterMarkerExpressionSegment) {
            return new ParameterMarkerLimitValueSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ((ParameterMarkerExpressionSegment)astNode).getParameterMarkerIndex());
        }
        return new NumberLiteralLimitValueSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), Long.parseLong(((LiteralExpressionSegment)astNode).getLiterals().toString()));
    }

    @Override
    public ASTNode visitSelectOffsetValue(OpenGaussStatementParser.SelectOffsetValueContext ctx) {
        ASTNode astNode = (ASTNode)this.visit((ParseTree)ctx.aExpr());
        if (astNode instanceof ParameterMarkerExpressionSegment) {
            return new ParameterMarkerLimitValueSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ((ParameterMarkerExpressionSegment)astNode).getParameterMarkerIndex());
        }
        return new NumberLiteralLimitValueSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), Long.parseLong(((LiteralExpressionSegment)astNode).getLiterals().toString()));
    }

    private LimitSegment createLimitSegmentWhenLimitAndOffset(OpenGaussStatementParser.SelectLimitContext ctx) {
        ParseTree astNode0 = ctx.getChild(0);
        LimitValueSegment rowCount = null;
        LimitValueSegment offset = null;
        if (astNode0 instanceof OpenGaussStatementParser.LimitClauseContext) {
            rowCount = null == ctx.limitClause().selectLimitValue() ? null : (LimitValueSegment)this.visit((ParseTree)ctx.limitClause().selectLimitValue());
        } else {
            offset = (LimitValueSegment)this.visit((ParseTree)ctx.offsetClause().selectOffsetValue());
        }
        ParseTree astNode1 = ctx.getChild(1);
        if (astNode1 instanceof OpenGaussStatementParser.LimitClauseContext) {
            rowCount = null == ctx.limitClause().selectLimitValue() ? null : (LimitValueSegment)this.visit((ParseTree)ctx.limitClause().selectLimitValue());
        } else {
            offset = (LimitValueSegment)this.visit((ParseTree)ctx.offsetClause().selectOffsetValue());
        }
        return new LimitSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (PaginationValueSegment)offset, (PaginationValueSegment)rowCount);
    }

    private LimitSegment createLimitSegmentWhenRowCountOrOffsetAbsent(OpenGaussStatementParser.SelectLimitContext ctx) {
        if (null != ctx.limitClause()) {
            if (null != ctx.limitClause().selectOffsetValue()) {
                LimitValueSegment limit = (LimitValueSegment)this.visit((ParseTree)ctx.limitClause().selectLimitValue());
                LimitValueSegment offset = (LimitValueSegment)this.visit((ParseTree)ctx.limitClause().selectOffsetValue());
                return new LimitSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (PaginationValueSegment)offset, (PaginationValueSegment)limit);
            }
            LimitValueSegment limit = (LimitValueSegment)this.visit((ParseTree)ctx.limitClause().selectLimitValue());
            return new LimitSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), null, (PaginationValueSegment)limit);
        }
        LimitValueSegment offset = (LimitValueSegment)this.visit((ParseTree)ctx.offsetClause().selectOffsetValue());
        return new LimitSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (PaginationValueSegment)offset, null);
    }

    @Override
    public ASTNode visitExecuteStmt(OpenGaussStatementParser.ExecuteStmtContext ctx) {
        return new OpenGaussExecuteStatement();
    }

    protected String getOriginalText(ParserRuleContext ctx) {
        return ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
    }

    @Generated
    public OpenGaussStatementSQLVisitor() {
    }

    @Generated
    protected int getCurrentParameterIndex() {
        return this.currentParameterIndex;
    }

    @Generated
    protected Collection<ParameterMarkerSegment> getParameterMarkerSegments() {
        return this.parameterMarkerSegments;
    }
}

