/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.oracle.visitor.statement.impl;

import java.util.Collections;
import java.util.LinkedList;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.operation.SQLStatementVisitor;
import org.apache.shardingsphere.sql.parser.api.visitor.type.DDLSQLVisitor;
import org.apache.shardingsphere.sql.parser.autogen.OracleStatementParser;
import org.apache.shardingsphere.sql.parser.oracle.visitor.statement.impl.OracleStatementSQLVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.AlterDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.CreateDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.alter.AddColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.alter.DropColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.alter.ModifyColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.constraint.ConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.DataTypeSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.oracle.ddl.OracleAlterIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.oracle.ddl.OracleAlterTableStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.oracle.ddl.OracleCreateIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.oracle.ddl.OracleCreateTableStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.oracle.ddl.OracleDropIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.oracle.ddl.OracleDropTableStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.oracle.ddl.OracleTruncateStatement;

public final class OracleDDLStatementSQLVisitor
extends OracleStatementSQLVisitor
implements DDLSQLVisitor,
SQLStatementVisitor {
    @Override
    public ASTNode visitCreateTable(OracleStatementParser.CreateTableContext ctx) {
        OracleCreateTableStatement result = new OracleCreateTableStatement();
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        if (null != ctx.createDefinitionClause()) {
            CollectionValue createDefinitions = (CollectionValue)this.visit((ParseTree)ctx.createDefinitionClause());
            for (CreateDefinitionSegment each : createDefinitions.getValue()) {
                if (each instanceof ColumnDefinitionSegment) {
                    result.getColumnDefinitions().add((ColumnDefinitionSegment)each);
                    continue;
                }
                if (!(each instanceof ConstraintDefinitionSegment)) continue;
                result.getConstraintDefinitions().add((ConstraintDefinitionSegment)each);
            }
        }
        return result;
    }

    @Override
    public ASTNode visitCreateDefinitionClause(OracleStatementParser.CreateDefinitionClauseContext ctx) {
        CollectionValue result = new CollectionValue();
        for (OracleStatementParser.RelationalPropertyContext each : ctx.relationalProperties().relationalProperty()) {
            if (null != each.columnDefinition()) {
                result.getValue().add((ColumnDefinitionSegment)this.visit((ParseTree)each.columnDefinition()));
            }
            if (null != each.outOfLineConstraint()) {
                result.getValue().add((ConstraintDefinitionSegment)this.visit((ParseTree)each.outOfLineConstraint()));
            }
            if (null == each.outOfLineRefConstraint()) continue;
            result.getValue().add((ConstraintDefinitionSegment)this.visit((ParseTree)each.outOfLineRefConstraint()));
        }
        return result;
    }

    @Override
    public ASTNode visitColumnDefinition(OracleStatementParser.ColumnDefinitionContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visit((ParseTree)ctx.columnName());
        DataTypeSegment dataType = (DataTypeSegment)this.visit((ParseTree)ctx.dataType());
        boolean isPrimaryKey = this.isPrimaryKey(ctx);
        ColumnDefinitionSegment result = new ColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), column, dataType, isPrimaryKey);
        for (OracleStatementParser.InlineConstraintContext each : ctx.inlineConstraint()) {
            if (null == each.referencesClause()) continue;
            result.getReferencedTables().add((SimpleTableSegment)this.visit((ParseTree)each.referencesClause().tableName()));
        }
        if (null != ctx.inlineRefConstraint()) {
            result.getReferencedTables().add((SimpleTableSegment)this.visit((ParseTree)ctx.inlineRefConstraint().tableName()));
        }
        return result;
    }

    private boolean isPrimaryKey(OracleStatementParser.ColumnDefinitionContext ctx) {
        for (OracleStatementParser.InlineConstraintContext each : ctx.inlineConstraint()) {
            if (null == each.primaryKey()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ASTNode visitOutOfLineConstraint(OracleStatementParser.OutOfLineConstraintContext ctx) {
        ConstraintDefinitionSegment result = new ConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        if (null != ctx.primaryKey()) {
            result.getPrimaryKeyColumns().addAll(((CollectionValue)this.visit((ParseTree)ctx.columnNames())).getValue());
        }
        if (null != ctx.referencesClause()) {
            result.setReferencedTable((SimpleTableSegment)this.visit((ParseTree)ctx.referencesClause().tableName()));
        }
        return result;
    }

    @Override
    public ASTNode visitOutOfLineRefConstraint(OracleStatementParser.OutOfLineRefConstraintContext ctx) {
        ConstraintDefinitionSegment result = new ConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        if (null != ctx.referencesClause()) {
            result.setReferencedTable((SimpleTableSegment)this.visit((ParseTree)ctx.referencesClause().tableName()));
        }
        return result;
    }

    @Override
    public ASTNode visitAlterTable(OracleStatementParser.AlterTableContext ctx) {
        OracleAlterTableStatement result = new OracleAlterTableStatement();
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        if (null != ctx.alterDefinitionClause()) {
            for (AlterDefinitionSegment each : ((CollectionValue)this.visit((ParseTree)ctx.alterDefinitionClause())).getValue()) {
                if (each instanceof AddColumnDefinitionSegment) {
                    result.getAddColumnDefinitions().add((AddColumnDefinitionSegment)each);
                    continue;
                }
                if (each instanceof ModifyColumnDefinitionSegment) {
                    result.getModifyColumnDefinitions().add((ModifyColumnDefinitionSegment)each);
                    continue;
                }
                if (each instanceof DropColumnDefinitionSegment) {
                    result.getDropColumnDefinitions().add((DropColumnDefinitionSegment)each);
                    continue;
                }
                if (!(each instanceof ConstraintDefinitionSegment)) continue;
                result.getAddConstraintDefinitions().add((ConstraintDefinitionSegment)each);
            }
        }
        return result;
    }

    @Override
    public ASTNode visitAlterDefinitionClause(OracleStatementParser.AlterDefinitionClauseContext ctx) {
        CollectionValue result = new CollectionValue();
        if (null != ctx.columnClauses()) {
            for (OracleStatementParser.OperateColumnClauseContext each : ctx.columnClauses().operateColumnClause()) {
                if (null != each.addColumnSpecification()) {
                    result.getValue().addAll(((CollectionValue)this.visit((ParseTree)each.addColumnSpecification())).getValue());
                }
                if (null != each.modifyColumnSpecification()) {
                    result.getValue().add((ModifyColumnDefinitionSegment)this.visit((ParseTree)each.modifyColumnSpecification()));
                }
                if (null == each.dropColumnClause()) continue;
                result.getValue().add((DropColumnDefinitionSegment)this.visit((ParseTree)each.dropColumnClause()));
            }
        }
        return result;
    }

    @Override
    public ASTNode visitAddColumnSpecification(OracleStatementParser.AddColumnSpecificationContext ctx) {
        CollectionValue result = new CollectionValue();
        for (OracleStatementParser.ColumnOrVirtualDefinitionContext each : ctx.columnOrVirtualDefinitions().columnOrVirtualDefinition()) {
            if (null == each.columnDefinition()) continue;
            AddColumnDefinitionSegment addColumnDefinition = new AddColumnDefinitionSegment(each.columnDefinition().getStart().getStartIndex(), each.columnDefinition().getStop().getStopIndex(), Collections.singletonList((ColumnDefinitionSegment)this.visit((ParseTree)each.columnDefinition())));
            result.getValue().add(addColumnDefinition);
        }
        return result;
    }

    @Override
    public ASTNode visitModifyColumnSpecification(OracleStatementParser.ModifyColumnSpecificationContext ctx) {
        ColumnDefinitionSegment columnDefinition = null;
        for (OracleStatementParser.ModifyColPropertiesContext each : ctx.modifyColProperties()) {
            columnDefinition = (ColumnDefinitionSegment)this.visit((ParseTree)each);
        }
        return new ModifyColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnDefinition);
    }

    @Override
    public ASTNode visitModifyColProperties(OracleStatementParser.ModifyColPropertiesContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visit((ParseTree)ctx.columnName());
        DataTypeSegment dataType = (DataTypeSegment)this.visit((ParseTree)ctx.dataType());
        return new ColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), column, dataType, false);
    }

    @Override
    public ASTNode visitDropColumnSpecification(OracleStatementParser.DropColumnSpecificationContext ctx) {
        LinkedList<ColumnSegment> columns = new LinkedList<ColumnSegment>();
        for (OracleStatementParser.ColumnNameContext each : ctx.columnOrColumnList().columnName()) {
            columns.add((ColumnSegment)this.visit((ParseTree)each));
        }
        return new DropColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columns);
    }

    @Override
    public ASTNode visitDropTable(OracleStatementParser.DropTableContext ctx) {
        OracleDropTableStatement result = new OracleDropTableStatement();
        result.getTables().add((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        return result;
    }

    @Override
    public ASTNode visitTruncateTable(OracleStatementParser.TruncateTableContext ctx) {
        OracleTruncateStatement result = new OracleTruncateStatement();
        result.getTables().add((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        return result;
    }

    @Override
    public ASTNode visitCreateIndex(OracleStatementParser.CreateIndexContext ctx) {
        OracleCreateIndexStatement result = new OracleCreateIndexStatement();
        if (null != ctx.createIndexDefinitionClause().tableIndexClause()) {
            result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.createIndexDefinitionClause().tableIndexClause().tableName()));
        }
        return result;
    }

    @Override
    public ASTNode visitAlterIndex(OracleStatementParser.AlterIndexContext ctx) {
        return new OracleAlterIndexStatement();
    }

    @Override
    public ASTNode visitDropIndex(OracleStatementParser.DropIndexContext ctx) {
        return new OracleDropIndexStatement();
    }
}

