/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.postgresql.visitor.statement.impl;

import com.google.common.base.Joiner;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.autogen.PostgreSQLStatementBaseVisitor;
import org.apache.shardingsphere.sql.parser.autogen.PostgreSQLStatementParser;
import org.apache.shardingsphere.sql.parser.sql.common.constant.AggregationType;
import org.apache.shardingsphere.sql.parser.sql.common.constant.OrderDirection;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BetweenExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.InExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ListExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.complex.CommonExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubqueryExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.AggregationDistinctProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.OrderBySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.ExpressionOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.IndexOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.OrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.DataTypeLengthSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.DataTypeSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.keyword.KeywordValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.literal.LiteralValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.literal.impl.BooleanLiteralValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.literal.impl.NumberLiteralValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.literal.impl.StringLiteralValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.parametermarker.ParameterMarkerValue;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.dml.PostgreSQLSelectStatement;

public abstract class PostgreSQLStatementSQLVisitor
extends PostgreSQLStatementBaseVisitor<ASTNode> {
    private int currentParameterIndex;

    @Override
    public final ASTNode visitParameterMarker(PostgreSQLStatementParser.ParameterMarkerContext ctx) {
        return new ParameterMarkerValue(Integer.valueOf(this.currentParameterIndex++));
    }

    @Override
    public final ASTNode visitNumberLiterals(PostgreSQLStatementParser.NumberLiteralsContext ctx) {
        return new NumberLiteralValue(ctx.getText());
    }

    @Override
    public final ASTNode visitIdentifier(PostgreSQLStatementParser.IdentifierContext ctx) {
        PostgreSQLStatementParser.UnreservedWordContext unreservedWord = ctx.unreservedWord();
        return null != unreservedWord ? (ASTNode)this.visit((ParseTree)unreservedWord) : new IdentifierValue(ctx.getText());
    }

    @Override
    public final ASTNode visitUnreservedWord(PostgreSQLStatementParser.UnreservedWordContext ctx) {
        return new IdentifierValue(ctx.getText());
    }

    @Override
    public final ASTNode visitSchemaName(PostgreSQLStatementParser.SchemaNameContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.identifier());
    }

    @Override
    public final ASTNode visitTableName(PostgreSQLStatementParser.TableNameContext ctx) {
        SimpleTableSegment result = new SimpleTableSegment(new TableNameSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.name())));
        PostgreSQLStatementParser.OwnerContext owner = ctx.owner();
        if (null != owner) {
            result.setOwner(new OwnerSegment(owner.getStart().getStartIndex(), owner.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)owner.identifier())));
        }
        return result;
    }

    @Override
    public final ASTNode visitColumnName(PostgreSQLStatementParser.ColumnNameContext ctx) {
        ColumnSegment result = new ColumnSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.name()));
        PostgreSQLStatementParser.OwnerContext owner = ctx.owner();
        if (null != owner) {
            result.setOwner(new OwnerSegment(owner.getStart().getStartIndex(), owner.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)owner.identifier())));
        }
        return result;
    }

    @Override
    public final ASTNode visitIndexName(PostgreSQLStatementParser.IndexNameContext ctx) {
        return new IndexSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier()));
    }

    @Override
    public final ASTNode visitTableNames(PostgreSQLStatementParser.TableNamesContext ctx) {
        CollectionValue result = new CollectionValue();
        for (PostgreSQLStatementParser.TableNameContext each : ctx.tableName()) {
            result.getValue().add((SimpleTableSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public final ASTNode visitColumnNames(PostgreSQLStatementParser.ColumnNamesContext ctx) {
        CollectionValue result = new CollectionValue();
        for (PostgreSQLStatementParser.ColumnNameContext each : ctx.columnName()) {
            result.getValue().add((ColumnSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitAExpr(PostgreSQLStatementParser.AExprContext ctx) {
        if (null != ctx.cExpr()) {
            return (ASTNode)this.visit((ParseTree)ctx.cExpr());
        }
        if (null != ctx.BETWEEN()) {
            return this.createBetweenSegment(ctx);
        }
        if (null != ctx.IN()) {
            return this.createInSegment(ctx);
        }
        if (null != ctx.comparisonOperator()) {
            ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.aExpr(0));
            ExpressionSegment right = (ExpressionSegment)this.visit((ParseTree)ctx.aExpr(1));
            String operator = ctx.comparisonOperator().getText();
            String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
            return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, right, operator, text);
        }
        if (null != ctx.logicalOperator()) {
            ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.aExpr(0));
            ExpressionSegment right = (ExpressionSegment)this.visit((ParseTree)ctx.aExpr(1));
            String operator = ctx.logicalOperator().getText();
            String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
            return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, right, operator, text);
        }
        super.visitAExpr(ctx);
        String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
        return new CommonExpressionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), text);
    }

    @Override
    public ASTNode visitCExpr(PostgreSQLStatementParser.CExprContext ctx) {
        if (null != ctx.columnref()) {
            return (ASTNode)this.visit((ParseTree)ctx.columnref());
        }
        if (null != ctx.parameterMarker()) {
            return new ParameterMarkerExpressionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), ((ParameterMarkerValue)this.visit((ParseTree)ctx.parameterMarker())).getValue().intValue());
        }
        if (null != ctx.aexprConst()) {
            ASTNode astNode = (ASTNode)this.visit((ParseTree)ctx.aexprConst());
            if (astNode instanceof StringLiteralValue || astNode instanceof BooleanLiteralValue || astNode instanceof NumberLiteralValue) {
                return new LiteralExpressionSegment(ctx.aexprConst().start.getStartIndex(), ctx.aexprConst().stop.getStopIndex(), ((LiteralValue)astNode).getValue());
            }
            return astNode;
        }
        if (null != ctx.aExpr()) {
            return (ASTNode)this.visit((ParseTree)ctx.aExpr());
        }
        super.visitCExpr(ctx);
        return new CommonExpressionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), ctx.getText());
    }

    @Override
    public ASTNode visitAexprConst(PostgreSQLStatementParser.AexprConstContext ctx) {
        if (null != ctx.NUMBER_()) {
            return new NumberLiteralValue(ctx.NUMBER_().getText());
        }
        if (null != ctx.STRING_()) {
            return new StringLiteralValue(ctx.STRING_().getText());
        }
        if (null != ctx.FALSE()) {
            return new BooleanLiteralValue(ctx.FALSE().getText());
        }
        if (null != ctx.TRUE()) {
            return new BooleanLiteralValue(ctx.TRUE().getText());
        }
        return new CommonExpressionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), ctx.getText());
    }

    @Override
    public ASTNode visitColumnref(PostgreSQLStatementParser.ColumnrefContext ctx) {
        if (null != ctx.indirection()) {
            PostgreSQLStatementParser.AttrNameContext attrName = ctx.indirection().indirectionEl().attrName();
            ColumnSegment result = new ColumnSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), new IdentifierValue(attrName.getText()));
            OwnerSegment owner = new OwnerSegment(ctx.colId().start.getStartIndex(), ctx.colId().stop.getStopIndex(), new IdentifierValue(ctx.colId().getText()));
            result.setOwner(owner);
            return result;
        }
        return new ColumnSegment(ctx.colId().start.getStartIndex(), ctx.colId().stop.getStopIndex(), new IdentifierValue(ctx.colId().getText()));
    }

    private InExpression createInSegment(PostgreSQLStatementParser.AExprContext ctx) {
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.aExpr(0));
        ExpressionSegment right = this.visitInExpression(ctx.inExpr());
        boolean not = null != ctx.NOT();
        return new InExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, right, not);
    }

    private ExpressionSegment visitInExpression(PostgreSQLStatementParser.InExprContext ctx) {
        if (null != ctx.selectWithParens()) {
            PostgreSQLSelectStatement select = (PostgreSQLSelectStatement)this.visit((ParseTree)ctx.selectWithParens());
            SubquerySegment subquerySegment = new SubquerySegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (SelectStatement)select);
            return new SubqueryExpressionSegment(subquerySegment);
        }
        return (ExpressionSegment)this.visit((ParseTree)ctx.exprList());
    }

    @Override
    public ASTNode visitExprList(PostgreSQLStatementParser.ExprListContext ctx) {
        ListExpression result = new ListExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        if (null != ctx.exprList()) {
            result.getItems().addAll(((ListExpression)this.visitExprList(ctx.exprList())).getItems());
        }
        result.getItems().add((ExpressionSegment)this.visit((ParseTree)ctx.aExpr()));
        return result;
    }

    private BetweenExpression createBetweenSegment(PostgreSQLStatementParser.AExprContext ctx) {
        ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.aExpr(0));
        ExpressionSegment between = (ExpressionSegment)this.visit((ParseTree)ctx.bExpr());
        ExpressionSegment and = (ExpressionSegment)this.visit((ParseTree)ctx.aExpr(1));
        boolean not = null != ctx.NOT();
        return new BetweenExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, between, and, not);
    }

    @Override
    public ASTNode visitBExpr(PostgreSQLStatementParser.BExprContext ctx) {
        if (null != ctx.cExpr()) {
            return (ASTNode)this.visit((ParseTree)ctx.cExpr());
        }
        if (null != ctx.TYPE_CAST_() || null != ctx.qualOp()) {
            ExpressionSegment right;
            String operator;
            ExpressionSegment left = (ExpressionSegment)this.visit((ParseTree)ctx.bExpr(0));
            if (null != ctx.TYPE_CAST_()) {
                operator = ctx.TYPE_CAST_().getText();
                right = new CommonExpressionSegment(ctx.typeName().start.getStartIndex(), ctx.typeName().stop.getStopIndex(), ctx.typeName().getText());
            } else {
                operator = ctx.qualOp().getText();
                right = (ExpressionSegment)this.visit((ParseTree)ctx.bExpr(1));
            }
            String text = ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
            return new BinaryOperationExpression(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), left, right, operator, text);
        }
        for (PostgreSQLStatementParser.BExprContext each : ctx.bExpr()) {
            this.visit((ParseTree)each);
        }
        return new LiteralExpressionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (Object)ctx.getText());
    }

    protected ProjectionSegment generateProjectFromFuncExpr(PostgreSQLStatementParser.FuncExprContext ctx) {
        if (null != ctx.funcApplication()) {
            return this.generateProjectFromFuncApplication(ctx.funcApplication());
        }
        return this.generateProjectFromFunctionExprCommonSubexpr(ctx.functionExprCommonSubexpr());
    }

    private ProjectionSegment generateProjectFromFuncApplication(PostgreSQLStatementParser.FuncApplicationContext ctx) {
        String aggregationType = ctx.funcName().getText();
        if (AggregationType.isAggregationType((String)aggregationType)) {
            return this.createAggregationSegment(ctx, aggregationType);
        }
        return new ExpressionProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText());
    }

    private ProjectionSegment generateProjectFromFunctionExprCommonSubexpr(PostgreSQLStatementParser.FunctionExprCommonSubexprContext ctx) {
        return new ExpressionProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText());
    }

    private ProjectionSegment createAggregationSegment(PostgreSQLStatementParser.FuncApplicationContext ctx, String aggregationType) {
        AggregationType type = AggregationType.valueOf((String)aggregationType.toUpperCase());
        String innerExpression = ctx.start.getInputStream().getText(new Interval(ctx.LP_().getSymbol().getStartIndex(), ctx.stop.getStopIndex()));
        if (null == ctx.DISTINCT()) {
            return new AggregationProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), type, innerExpression);
        }
        return new AggregationDistinctProjectionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), type, innerExpression, this.getDistinctExpression(ctx));
    }

    private String getDistinctExpression(PostgreSQLStatementParser.FuncApplicationContext ctx) {
        StringBuilder result = new StringBuilder();
        result.append(ctx.funcArgList().getText());
        if (null != ctx.sortClause()) {
            result.append(ctx.sortClause().getText());
        }
        return result.toString();
    }

    @Override
    public final ASTNode visitDataTypeName(PostgreSQLStatementParser.DataTypeNameContext ctx) {
        PostgreSQLStatementParser.IdentifierContext identifierContext = ctx.identifier();
        if (null != identifierContext) {
            return new KeywordValue(identifierContext.getText());
        }
        LinkedList<String> dataTypeNames = new LinkedList<String>();
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            dataTypeNames.add(ctx.getChild(i).getText());
        }
        return new KeywordValue(Joiner.on((String)" ").join(dataTypeNames));
    }

    @Override
    public final ASTNode visitSortClause(PostgreSQLStatementParser.SortClauseContext ctx) {
        LinkedList<OrderByItemSegment> items = new LinkedList<OrderByItemSegment>();
        for (PostgreSQLStatementParser.SortbyContext each : ctx.sortbyList().sortby()) {
            items.add((OrderByItemSegment)this.visit((ParseTree)each));
        }
        return new OrderBySegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), items);
    }

    @Override
    public final ASTNode visitSortby(PostgreSQLStatementParser.SortbyContext ctx) {
        OrderDirection orderDirection = null != ctx.ascDesc() ? this.generateOrderDirection(ctx.ascDesc()) : OrderDirection.ASC;
        ASTNode astNode = (ASTNode)this.visit((ParseTree)ctx.aExpr());
        if (astNode instanceof ColumnSegment) {
            ColumnSegment column = (ColumnSegment)astNode;
            return new ColumnOrderByItemSegment(column, orderDirection);
        }
        if (astNode instanceof LiteralExpressionSegment) {
            LiteralExpressionSegment index = (LiteralExpressionSegment)astNode;
            return new IndexOrderByItemSegment(index.getStartIndex(), index.getStopIndex(), Integer.parseInt(index.getLiterals().toString()), orderDirection);
        }
        return new ExpressionOrderByItemSegment(ctx.aExpr().getStart().getStartIndex(), ctx.aExpr().getStop().getStopIndex(), ctx.aExpr().getText(), orderDirection);
    }

    private OrderDirection generateOrderDirection(PostgreSQLStatementParser.AscDescContext ctx) {
        return null == ctx.DESC() ? OrderDirection.ASC : OrderDirection.DESC;
    }

    @Override
    public final ASTNode visitDataType(PostgreSQLStatementParser.DataTypeContext ctx) {
        DataTypeSegment result = new DataTypeSegment();
        result.setDataTypeName(((KeywordValue)this.visit((ParseTree)ctx.dataTypeName())).getValue());
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        if (null != ctx.dataTypeLength()) {
            DataTypeLengthSegment dataTypeLengthSegment = (DataTypeLengthSegment)this.visit((ParseTree)ctx.dataTypeLength());
            result.setDataLength(dataTypeLengthSegment);
        }
        return result;
    }

    @Override
    public final ASTNode visitDataTypeLength(PostgreSQLStatementParser.DataTypeLengthContext ctx) {
        DataTypeLengthSegment result = new DataTypeLengthSegment();
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStartIndex());
        List<TerminalNode> numbers = ctx.NUMBER_();
        if (1 == numbers.size()) {
            result.setPrecision(Integer.parseInt(numbers.get(0).getText()));
        }
        if (2 == numbers.size()) {
            result.setPrecision(Integer.parseInt(numbers.get(0).getText()));
            result.setScale(Integer.parseInt(numbers.get(1).getText()));
        }
        return result;
    }

    @Generated
    protected int getCurrentParameterIndex() {
        return this.currentParameterIndex;
    }
}

